/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.Client;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.cp.internal.CPSubsystemImpl;
import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.ClientDynamicClusterConfig;
import com.hazelcast.client.impl.clientside.ClientICacheManager;
import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.ClientSchemaService;
import com.hazelcast.client.impl.clientside.ClusterDiscoveryService;
import com.hazelcast.client.impl.clientside.ClusterDiscoveryServiceBuilder;
import com.hazelcast.client.impl.clientside.DefaultClientExtension;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.tcp.ClientICMPManager;
import com.hazelcast.client.impl.connection.tcp.HeartbeatManager;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnectionManager;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.proxy.ClientClusterProxy;
import com.hazelcast.client.impl.proxy.PartitionServiceProxy;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.client.impl.spi.ProxyManager;
import com.hazelcast.client.impl.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientUserCodeDeploymentService;
import com.hazelcast.client.impl.spi.impl.listener.ClientClusterViewListenerService;
import com.hazelcast.client.impl.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.impl.statistics.ClientStatisticsService;
import com.hazelcast.client.map.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.NetworkingImbalancePlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.metrics.impl.MetricsConfigHelper;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.jet.JetService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private final ConcurrencyDetection concurrencyDetection;
    private final HazelcastProperties properties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientFailoverConfig clientFailoverConfig;
    private final ClientConfig config;
    private final LifecycleServiceImpl lifecycleService;
    private final TcpClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationServiceImpl invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientClusterViewListenerService clientClusterViewListenerService;
    private final ClientTransactionManagerServiceImpl transactionManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final LoggingService loggingService;
    private final MetricsRegistryImpl metricsRegistry;
    private final ClientStatisticsService clientStatisticsService;
    private final Diagnostics diagnostics;
    private final ClientSchemaService schemaService;
    private final InternalSerializationService serializationService;
    private final ClientICacheManager hazelcastCacheManager;
    private final ClientQueryCacheContext queryCacheContext;
    private final ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private final ClientExceptionFactory clientExceptionFactory;
    private final ClientUserCodeDeploymentService userCodeDeploymentService;
    private final ClusterDiscoveryService clusterDiscoveryService;
    private final ClientProxySessionManager proxySessionManager;
    private final CPSubsystemImpl cpSubsystem;
    private final ConcurrentLinkedQueue<Disposable> onClusterChangeDisposables = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Disposable> onClientShutdownDisposables = new ConcurrentLinkedQueue();
    private final SqlClientService sqlService;

    public HazelcastClientInstanceImpl(String instanceName, ClientConfig clientConfig, ClientFailoverConfig clientFailoverConfig, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        this.config = clientConfig != null ? clientConfig : clientFailoverConfig.getClientConfigs().get(0);
        this.clientFailoverConfig = clientFailoverConfig;
        this.instanceName = instanceName;
        HazelcastProperties props = new HazelcastProperties(this.config.getProperties());
        String loggingType = props.getString(ClusterProperty.LOGGING_TYPE);
        boolean detailsEnabled = props.getBoolean(ClusterProperty.LOGGING_ENABLE_DETAILS);
        this.loggingService = new ClientLoggingService(this.config.getClusterName(), loggingType, BuildInfoProvider.getBuildInfo(), instanceName, detailsEnabled);
        if (clientConfig != null) {
            MetricsConfigHelper.overrideClientMetricsConfig(clientConfig, this.getLoggingService().getLogger(MetricsConfigHelper.class));
        } else {
            for (ClientConfig failoverClientConfig : clientFailoverConfig.getClientConfigs()) {
                MetricsConfigHelper.overrideClientMetricsConfig(failoverClientConfig, this.getLoggingService().getLogger(MetricsConfigHelper.class));
            }
        }
        ClassLoader classLoader = this.config.getClassLoader();
        this.properties = new HazelcastProperties(this.config.getProperties());
        this.concurrencyDetection = this.initConcurrencyDetection();
        this.clientExtension = this.createClientInitializer(classLoader);
        this.clientExtension.beforeStart(this);
        this.clientExtension.logInstanceTrackingMetadata();
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.metricsRegistry = this.initMetricsRegistry();
        this.schemaService = new ClientSchemaService(this, this.getLoggingService().getLogger(ClientSchemaService.class));
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.loadBalancer = this.initLoadBalancer(this.config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.clusterDiscoveryService = this.initClusterDiscoveryService(externalAddressProvider);
        this.connectionManager = (TcpClientConnectionManager)clientConnectionManagerFactory.createConnectionManager(this);
        this.invocationService = new ClientInvocationServiceImpl(this);
        this.listenerService = new ClientListenerServiceImpl(this);
        this.clusterService = new ClientClusterServiceImpl(this);
        this.clientClusterViewListenerService = new ClientClusterViewListenerService(this);
        this.userContext.putAll(this.config.getUserContext());
        this.diagnostics = this.initDiagnostics();
        this.hazelcastCacheManager = new ClientICacheManager(this);
        this.queryCacheContext = new ClientQueryCacheContext(this);
        this.lockReferenceIdGenerator = new ClientLockReferenceIdGenerator();
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.clientStatisticsService = new ClientStatisticsService(this);
        this.userCodeDeploymentService = new ClientUserCodeDeploymentService(this.config.getUserCodeDeploymentConfig(), classLoader);
        this.proxySessionManager = new ClientProxySessionManager(this);
        this.cpSubsystem = new CPSubsystemImpl(this);
        this.sqlService = new SqlClientService(this);
    }

    private ConcurrencyDetection initConcurrencyDetection() {
        boolean backPressureEnabled;
        boolean writeThrough = this.properties.getBoolean(ClientProperty.IO_WRITE_THROUGH_ENABLED);
        boolean dynamicResponse = this.properties.getBoolean(ClientProperty.RESPONSE_THREAD_DYNAMIC);
        boolean bl = backPressureEnabled = this.properties.getInteger(ClientProperty.MAX_CONCURRENT_INVOCATIONS) < Integer.MAX_VALUE;
        if (writeThrough || dynamicResponse || backPressureEnabled) {
            return ConcurrencyDetection.createEnabled(this.properties.getInteger(ClientProperty.CONCURRENT_WINDOW_MS));
        }
        return ConcurrencyDetection.createDisabled();
    }

    private ClusterDiscoveryService initClusterDiscoveryService(AddressProvider externalAddressProvider) {
        List<ClientConfig> configs;
        int tryCount;
        if (this.clientFailoverConfig == null) {
            tryCount = 0;
            configs = Collections.singletonList(this.config);
        } else {
            tryCount = this.clientFailoverConfig.getTryCount();
            configs = this.clientFailoverConfig.getClientConfigs();
        }
        ClusterDiscoveryServiceBuilder builder = new ClusterDiscoveryServiceBuilder(tryCount, configs, this.loggingService, externalAddressProvider, this.properties, this.clientExtension, this.getLifecycleService());
        return builder.build();
    }

    private Diagnostics initDiagnostics() {
        String name = "diagnostics-client-" + this.id + "-" + System.currentTimeMillis();
        return new Diagnostics(name, this.loggingService, this.instanceName, this.properties);
    }

    private MetricsRegistryImpl initMetricsRegistry() {
        ILogger logger = this.loggingService.getLogger(MetricsRegistryImpl.class);
        return new MetricsRegistryImpl(this.getName(), logger, MetricsConfigHelper.clientMetricsLevel(this.properties, this.loggingService.getLogger(MetricsConfigHelper.class)));
    }

    private void startMetrics() {
        RuntimeMetricSet.register(this.metricsRegistry);
        GarbageCollectionMetricSet.register(this.metricsRegistry);
        OperatingSystemMetricSet.register(this.metricsRegistry);
        ThreadMetricSet.register(this.metricsRegistry);
        ClassLoadingMetricSet.register(this.metricsRegistry);
        FileMetricSet.register(this.metricsRegistry);
        this.metricsRegistry.registerStaticMetrics(this.clientExtension.getMemoryStats(), "memory");
        this.metricsRegistry.provideMetrics(this.clientExtension);
        this.metricsRegistry.provideMetrics(this.executionService);
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            if (config.getLoadBalancerClassName() != null) {
                try {
                    return (LoadBalancer)ClassLoaderUtil.newInstance(config.getClassLoader(), config.getLoadBalancerClassName());
                }
                catch (Exception e) {
                    ExceptionUtil.rethrow(e);
                }
            } else {
                lb = new RoundRobinLB();
            }
        }
        return lb;
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator<ClientExtension> iter = ServiceLoader.iterator(ClientExtension.class, factoryId, classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultClientExtension();
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.config.getClassLoader(), this.properties, this.loggingService);
    }

    public void start() {
        try {
            this.lifecycleService.start();
            this.startMetrics();
            this.invocationService.start();
            ClientContext clientContext = new ClientContext(this);
            this.userCodeDeploymentService.start();
            Collection<EventListener> configuredListeners = this.instantiateConfiguredListenerObjects();
            this.clusterService.start(configuredListeners);
            this.clientClusterViewListenerService.start();
            this.connectionManager.start();
            this.startHeartbeat();
            this.startIcmpPing();
            this.connectionManager.connectToCluster();
            this.diagnostics.start();
            this.diagnostics.register(new BuildInfoPlugin(this.loggingService.getLogger(BuildInfoPlugin.class)));
            this.diagnostics.register(new ConfigPropertiesPlugin(this.loggingService.getLogger(ConfigPropertiesPlugin.class), this.properties));
            this.diagnostics.register(new SystemPropertiesPlugin(this.loggingService.getLogger(SystemPropertiesPlugin.class)));
            this.diagnostics.register(new MetricsPlugin(this.loggingService.getLogger(MetricsPlugin.class), this.metricsRegistry, this.properties));
            this.diagnostics.register(new SystemLogPlugin(this.properties, this.connectionManager, this, this.loggingService.getLogger(SystemLogPlugin.class)));
            this.diagnostics.register(new NetworkingImbalancePlugin(this.properties, this.connectionManager.getNetworking(), this.loggingService.getLogger(NetworkingImbalancePlugin.class)));
            this.diagnostics.register(new EventQueuePlugin(this.loggingService.getLogger(EventQueuePlugin.class), this.listenerService.getEventExecutor(), this.properties));
            this.metricsRegistry.provideMetrics(this.listenerService);
            ClientConnectionStrategyConfig connectionStrategyConfig = this.config.getConnectionStrategyConfig();
            boolean asyncStart = connectionStrategyConfig.isAsyncStart();
            if (!asyncStart) {
                this.waitForInitialMembershipEvents();
            }
            this.connectionManager.tryConnectToAllClusterMembers(!asyncStart);
            this.listenerService.start();
            this.proxyManager.init(this.config, clientContext);
            this.invocationService.addBackupListener();
            this.loadBalancer.init(this.getCluster(), this.config);
            this.clientStatisticsService.start();
            this.clientExtension.afterStart(this);
            this.cpSubsystem.init(clientContext);
            this.addClientConfigAddedListeners(configuredListeners);
            this.sendStateToCluster();
        }
        catch (Throwable e) {
            try {
                this.lifecycleService.terminate();
            }
            catch (Throwable t) {
                EmptyStatement.ignore(t);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void startHeartbeat() {
        long heartbeatTimeout = this.properties.getPositiveMillisOrDefault(ClientProperty.HEARTBEAT_TIMEOUT);
        long heartbeatInterval = this.properties.getPositiveMillisOrDefault(ClientProperty.HEARTBEAT_INTERVAL);
        ILogger logger = this.loggingService.getLogger(HeartbeatManager.class);
        HeartbeatManager.start(this, this.executionService, logger, heartbeatInterval, heartbeatTimeout, Collections.unmodifiableCollection(this.connectionManager.getActiveConnections()));
    }

    private void startIcmpPing() {
        ILogger logger = this.loggingService.getLogger(HeartbeatManager.class);
        ClientICMPManager.start(this.config.getNetworkConfig().getClientIcmpPingConfig(), this.executionService, logger, Collections.unmodifiableCollection(this.connectionManager.getActiveConnections()));
    }

    public void disposeOnClusterChange(Disposable disposable) {
        this.onClusterChangeDisposables.add(disposable);
    }

    public void disposeOnClientShutdown(Disposable disposable) {
        this.onClientShutdownDisposables.add(disposable);
    }

    public MetricsRegistryImpl getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return new ClientDynamicClusterConfig(this);
    }

    public HazelcastProperties getProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.instanceName;
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a queue instance with a null name is not allowed!");
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a set instance with a null name is not allowed!");
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a list instance with a null name is not allowed!");
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a map instance with a null name is not allowed!");
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a multi-map instance with a null name is not allowed!");
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a replicated map instance with a null name is not allowed!");
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a ringbuffer instance with a null name is not allowed!");
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    @Override
    public ClientICacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    @Override
    @Nonnull
    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an executor instance with a null name is not allowed!");
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a durable executor instance with a null name is not allowed!");
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        Preconditions.checkNotNull(options, "TransactionOptions must not be null!");
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a Flake ID-generator instance with a null name is not allowed!");
        return (FlakeIdGenerator)this.getDistributedObject("hz:impl:flakeIdGeneratorService", name);
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a cardinality estimator instance with a null name is not allowed!");
        return (CardinalityEstimator)this.getDistributedObject("hz:impl:cardinalityEstimatorService", name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a PN counter instance with a null name is not allowed!");
        return (PNCounter)this.getDistributedObject("hz:impl:PNCounterService", name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a scheduled executor instance with a null name is not allowed!");
        return (IScheduledExecutorService)this.getDistributedObject("hz:impl:scheduledExecutorService", name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request, this.getName()).invoke();
            ClientMessage response = (ClientMessage)future.get();
            Collection<? extends DistributedObject> distributedObjects = this.proxyManager.getDistributedObjects();
            HashSet<DistributedObjectInfo> localDistributedObjects = new HashSet<DistributedObjectInfo>();
            for (DistributedObject distributedObject : distributedObjects) {
                localDistributedObjects.add(new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName()));
            }
            for (DistributedObjectInfo distributedObjectInfo : ClientGetDistributedObjectsCodec.decodeResponse(response)) {
                localDistributedObjects.remove(distributedObjectInfo);
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName(), false);
            }
            for (DistributedObjectInfo distributedObjectInfo : localDistributedObjects) {
                this.proxyManager.destroyProxyLocally(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        Preconditions.checkNotNull(distributedObjectListener, "DistributedObjectListener must not be null!");
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Registration ID must not be null!");
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService, this.clusterService);
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.getDistributedObject(serviceName, name, true);
    }

    private <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name, boolean remote) {
        if (remote) {
            return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
        }
        return (T)this.proxyManager.getOrCreateLocalProxy(serviceName, name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.cpSubsystem;
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientUserCodeDeploymentService getUserCodeDeploymentService() {
        return this.userCodeDeploymentService;
    }

    public ClientProxySessionManager getProxySessionManager() {
        return this.proxySessionManager;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public TaskScheduler getTaskScheduler() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    void onGracefulShutdown() {
        this.proxySessionManager.shutdownAndAwait();
    }

    public void doShutdown() {
        HazelcastClientInstanceImpl.dispose(this.onClientShutdownDisposables);
        this.proxyManager.destroy();
        this.connectionManager.shutdown();
        this.clusterDiscoveryService.shutdown();
        this.transactionManager.shutdown();
        this.invocationService.shutdown();
        this.executionService.shutdown();
        this.listenerService.shutdown();
        this.clientStatisticsService.shutdown();
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
        this.serializationService.dispose();
    }

    private static void dispose(Queue<Disposable> queue) {
        Disposable disposable;
        while ((disposable = queue.poll()) != null) {
            disposable.dispose();
        }
    }

    public ClientLockReferenceIdGenerator getLockReferenceIdGenerator() {
        return this.lockReferenceIdGenerator;
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jCacheAvailable = JCacheDetector.isJCacheAvailable(this.getClientConfig().getClassLoader());
        return new ClientExceptionFactory(jCacheAvailable, this.config.getClassLoader());
    }

    public ClientExceptionFactory getClientExceptionFactory() {
        return this.clientExceptionFactory;
    }

    public ClusterDiscoveryService getClusterDiscoveryService() {
        return this.clusterDiscoveryService;
    }

    public ClientFailoverConfig getFailoverConfig() {
        return this.clientFailoverConfig;
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    public ConcurrencyDetection getConcurrencyDetection() {
        return this.concurrencyDetection;
    }

    @Override
    @Nonnull
    public SqlService getSql() {
        return this.sqlService;
    }

    @Override
    @Nonnull
    public JetService getJet() {
        return this.clientExtension.getJet();
    }

    public void onClusterChange() {
        ILogger logger = this.loggingService.getLogger(HazelcastInstance.class);
        logger.info("Resetting local state of the client, because of a cluster change.");
        HazelcastClientInstanceImpl.dispose(this.onClusterChangeDisposables);
        this.clusterService.reset();
        this.partitionService.reset();
        this.connectionManager.reset();
    }

    public void onClusterRestart() {
        ILogger logger = this.loggingService.getLogger(HazelcastInstance.class);
        logger.info("Clearing local state of the client, because of a cluster restart.");
        HazelcastClientInstanceImpl.dispose(this.onClusterChangeDisposables);
        this.clusterService.clearMemberList();
    }

    public void waitForInitialMembershipEvents() {
        this.clusterService.waitInitialMemberListFetched();
    }

    public void sendStateToCluster() throws ExecutionException, InterruptedException {
        this.userCodeDeploymentService.deploy(this);
        this.schemaService.sendAllSchemas();
        this.queryCacheContext.recreateAllCaches();
        this.proxyManager.createDistributedObjectsOnCluster();
    }

    public ClientStatisticsService getClientStatisticsService() {
        return this.clientStatisticsService;
    }

    private Collection<EventListener> instantiateConfiguredListenerObjects() {
        return this.config.getListenerConfigs().stream().map(listenerConfig -> {
            EventListener listener = listenerConfig.getImplementation();
            if (listener == null) {
                try {
                    listener = (EventListener)ClassLoaderUtil.newInstance(this.config.getClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    this.getLoggingService().getLogger(HazelcastInstance.class).severe(e);
                }
            }
            return listener;
        }).collect(Collectors.toList());
    }

    private void addClientConfigAddedListeners(Collection<EventListener> configuredListeners) {
        configuredListeners.stream().filter(listener -> listener instanceof DistributedObjectListener).forEach(listener -> this.proxyManager.addDistributedObjectListener((DistributedObjectListener)listener));
        configuredListeners.stream().filter(listener -> listener instanceof MigrationListener).forEach(listener -> this.getPartitionService().addMigrationListener((MigrationListener)listener));
        configuredListeners.stream().filter(listener -> listener instanceof PartitionLostListener).forEach(listener -> this.getPartitionService().addPartitionLostListener((PartitionLostListener)listener));
        configuredListeners.stream().filter(listener -> listener instanceof CPMembershipListener).forEach(listener -> this.getCPSubsystem().addMembershipListener((CPMembershipListener)listener));
        configuredListeners.stream().filter(listener -> listener instanceof CPGroupAvailabilityListener).forEach(listener -> this.getCPSubsystem().addGroupAvailabilityListener((CPGroupAvailabilityListener)listener));
    }

    public SchemaService getSchemaService() {
        return this.schemaService;
    }
}

