/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;

public class RequestSplitOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private TaskLocation enumeratorTaskID;
    private TaskLocation taskLocation;

    public RequestSplitOperation() {
    }

    public RequestSplitOperation(TaskLocation taskLocation, TaskLocation enumeratorTaskID) {
        this.enumeratorTaskID = enumeratorTaskID;
        this.taskLocation = taskLocation;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            ClassLoader classLoader = server.getTaskExecutionService().getExecutionContext(this.enumeratorTaskID.getTaskGroupLocation()).getClassLoader(this.taskLocation.getTaskID());
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.enumeratorTaskID);
            task.requestSplit(this.taskLocation.getTaskIndex());
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.enumeratorTaskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.taskLocation);
        out.writeObject(this.enumeratorTaskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskLocation = (TaskLocation)in.readObject();
        this.enumeratorTaskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

