/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.sink;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SinkAggregatedCommitterTask;
import org.apache.seatunnel.engine.server.task.operation.checkpoint.BarrierFlowOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class SinkPrepareCommitOperation<CommitInfoT>
extends BarrierFlowOperation {
    private byte[] commitInfos;

    public SinkPrepareCommitOperation(Barrier checkpointBarrier, TaskLocation taskLocation, byte[] commitInfos) {
        super(checkpointBarrier, taskLocation);
        this.commitInfos = commitInfos;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeByteArray(this.commitInfos);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.commitInfos = in.readByteArray();
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runInternal() throws Exception {
        TaskExecutionService taskExecutionService = ((SeaTunnelServer)this.getService()).getTaskExecutionService();
        SinkAggregatedCommitterTask committerTask = (SinkAggregatedCommitterTask)taskExecutionService.getTask(this.taskLocation);
        ClassLoader taskClassLoader = taskExecutionService.getExecutionContext(this.taskLocation.getTaskGroupLocation()).getClassLoader(committerTask.getTaskID());
        ClassLoader mainClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.commitInfos != null) {
            Object deserializeCommitInfo = null;
            try {
                Thread.currentThread().setContextClassLoader(taskClassLoader);
                deserializeCommitInfo = committerTask.getCommitInfoSerializer().deserialize(this.commitInfos);
            }
            finally {
                Thread.currentThread().setContextClassLoader(mainClassLoader);
            }
            committerTask.receivedWriterCommitInfo(this.barrier.getId(), deserializeCommitInfo);
        }
        committerTask.triggerBarrier(this.barrier);
    }

    public SinkPrepareCommitOperation() {
    }
}

