/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.splitbrainprotection.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.SplitBrainProtectionCheckAwareOperation;
import com.hazelcast.splitbrainprotection.HeartbeatAware;
import com.hazelcast.splitbrainprotection.PingAware;
import com.hazelcast.splitbrainprotection.SplitBrainProtection;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionEvent;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.splitbrainprotection.impl.MemberCountSplitBrainProtectionFunction;
import java.util.Collection;

public class SplitBrainProtectionImpl
implements SplitBrainProtection {
    private final NodeEngineImpl nodeEngine;
    private final String splitBrainProtectionName;
    private final int minimumClusterSize;
    private final SplitBrainProtectionConfig config;
    private final EventService eventService;
    private final SplitBrainProtectionFunction splitBrainProtectionFunction;
    private final boolean heartbeatAwareSplitBrainProtectionFunction;
    private final boolean pingAwareSplitBrainProtectionFunction;
    private final boolean membershipListenerSplitBrainProtectionFunction;
    private volatile SplitBrainProtectionState splitBrainProtectionState = SplitBrainProtectionState.INITIAL;

    SplitBrainProtectionImpl(SplitBrainProtectionConfig config, NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.config = config;
        this.splitBrainProtectionName = config.getName();
        this.minimumClusterSize = config.getMinimumClusterSize();
        this.splitBrainProtectionFunction = this.initializeSplitBrainProtectionFunction();
        this.heartbeatAwareSplitBrainProtectionFunction = this.splitBrainProtectionFunction instanceof HeartbeatAware;
        this.membershipListenerSplitBrainProtectionFunction = this.splitBrainProtectionFunction instanceof MembershipListener;
        this.pingAwareSplitBrainProtectionFunction = this.splitBrainProtectionFunction instanceof PingAware;
    }

    void update(Collection<Member> members) {
        SplitBrainProtectionState previousSplitBrainProtectionState = this.splitBrainProtectionState;
        SplitBrainProtectionState newSplitBrainProtectionState = SplitBrainProtectionState.NO_MIN_CLUSTER_SIZE;
        try {
            boolean present = this.splitBrainProtectionFunction.apply(members);
            newSplitBrainProtectionState = present ? SplitBrainProtectionState.HAS_MIN_CLUSTER_SIZE : SplitBrainProtectionState.NO_MIN_CLUSTER_SIZE;
        }
        catch (Exception e) {
            ILogger logger = this.nodeEngine.getLogger(SplitBrainProtectionService.class);
            logger.severe("Split brain protection function of split brain protection: " + this.splitBrainProtectionName + " failed! Split brain protection status is set to " + (Object)((Object)newSplitBrainProtectionState), e);
        }
        if (previousSplitBrainProtectionState == SplitBrainProtectionState.INITIAL && newSplitBrainProtectionState != SplitBrainProtectionState.HAS_MIN_CLUSTER_SIZE) {
            return;
        }
        this.splitBrainProtectionState = newSplitBrainProtectionState;
        if (previousSplitBrainProtectionState == SplitBrainProtectionState.INITIAL) {
            return;
        }
        if (previousSplitBrainProtectionState != newSplitBrainProtectionState) {
            this.createAndPublishEvent(members, newSplitBrainProtectionState == SplitBrainProtectionState.HAS_MIN_CLUSTER_SIZE);
        }
    }

    void onHeartbeat(Member member, long timestamp) {
        if (!this.heartbeatAwareSplitBrainProtectionFunction) {
            return;
        }
        ((HeartbeatAware)((Object)this.splitBrainProtectionFunction)).onHeartbeat(member, timestamp);
    }

    void onPing(Member member, boolean successful) {
        if (!this.pingAwareSplitBrainProtectionFunction) {
            return;
        }
        PingAware pingAware = (PingAware)((Object)this.splitBrainProtectionFunction);
        if (successful) {
            pingAware.onPingRestored(member);
        } else {
            pingAware.onPingLost(member);
        }
    }

    void onMemberAdded(MembershipEvent event) {
        if (!this.membershipListenerSplitBrainProtectionFunction) {
            return;
        }
        ((MembershipListener)((Object)this.splitBrainProtectionFunction)).memberAdded(event);
    }

    void onMemberRemoved(MembershipEvent event) {
        if (!this.membershipListenerSplitBrainProtectionFunction) {
            return;
        }
        ((MembershipListener)((Object)this.splitBrainProtectionFunction)).memberRemoved(event);
    }

    public String getName() {
        return this.splitBrainProtectionName;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public SplitBrainProtectionConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean hasMinimumSize() {
        return this.splitBrainProtectionState == SplitBrainProtectionState.HAS_MIN_CLUSTER_SIZE;
    }

    boolean isHeartbeatAware() {
        return this.heartbeatAwareSplitBrainProtectionFunction;
    }

    boolean isPingAware() {
        return this.pingAwareSplitBrainProtectionFunction;
    }

    private boolean isSplitBrainProtectionNeeded(Operation op) {
        SplitBrainProtectionOn type = this.config.getProtectOn();
        switch (type) {
            case WRITE: {
                return SplitBrainProtectionImpl.isWriteOperation(op) && SplitBrainProtectionImpl.shouldCheckSplitBrainProtection(op);
            }
            case READ: {
                return SplitBrainProtectionImpl.isReadOperation(op) && SplitBrainProtectionImpl.shouldCheckSplitBrainProtection(op);
            }
            case READ_WRITE: {
                return (SplitBrainProtectionImpl.isReadOperation(op) || SplitBrainProtectionImpl.isWriteOperation(op)) && SplitBrainProtectionImpl.shouldCheckSplitBrainProtection(op);
            }
        }
        throw new IllegalStateException("Unhandled split brain protection type: " + (Object)((Object)type));
    }

    private static boolean isReadOperation(Operation op) {
        return op instanceof ReadonlyOperation;
    }

    private static boolean isWriteOperation(Operation op) {
        return op instanceof MutatingOperation;
    }

    private static boolean shouldCheckSplitBrainProtection(Operation op) {
        return !(op instanceof SplitBrainProtectionCheckAwareOperation) || ((SplitBrainProtectionCheckAwareOperation)((Object)op)).shouldCheckSplitBrainProtection();
    }

    void ensureNoSplitBrain(Operation op) {
        if (!this.isSplitBrainProtectionNeeded(op)) {
            return;
        }
        this.ensureNoSplitBrain();
    }

    void ensureNoSplitBrain() {
        if (!this.hasMinimumSize()) {
            throw this.newSplitBrainProtectionException();
        }
    }

    private SplitBrainProtectionException newSplitBrainProtectionException() {
        throw new SplitBrainProtectionException("Split brain protection exception: " + this.splitBrainProtectionName + " has failed!");
    }

    private void createAndPublishEvent(Collection<Member> memberList, boolean presence) {
        SplitBrainProtectionEvent splitBrainProtectionEvent = new SplitBrainProtectionEvent(this.nodeEngine.getThisAddress(), this.minimumClusterSize, memberList, presence);
        this.eventService.publishEvent("hz:impl:splitBrainProtectionService", this.splitBrainProtectionName, (Object)splitBrainProtectionEvent, splitBrainProtectionEvent.hashCode());
    }

    private SplitBrainProtectionFunction initializeSplitBrainProtectionFunction() {
        SplitBrainProtectionFunction splitBrainProtectionFunction = this.config.getFunctionImplementation();
        if (splitBrainProtectionFunction == null && this.config.getFunctionClassName() != null) {
            try {
                splitBrainProtectionFunction = (SplitBrainProtectionFunction)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), this.config.getFunctionClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (splitBrainProtectionFunction == null) {
            splitBrainProtectionFunction = new MemberCountSplitBrainProtectionFunction(this.minimumClusterSize);
        }
        ManagedContext managedContext = this.nodeEngine.getSerializationService().getManagedContext();
        splitBrainProtectionFunction = (SplitBrainProtectionFunction)managedContext.initialize(splitBrainProtectionFunction);
        return splitBrainProtectionFunction;
    }

    public String toString() {
        return "SplitBrainProtectionImpl{splitBrainProtectionName='" + this.splitBrainProtectionName + '\'' + ", isMinimumClusterSizeSatisfied=" + this.hasMinimumSize() + ", minimumClusterSize=" + this.minimumClusterSize + ", config=" + this.config + ", splitBrainProtectionFunction=" + this.splitBrainProtectionFunction + '}';
    }

    private static enum SplitBrainProtectionState {
        INITIAL,
        HAS_MIN_CLUSTER_SIZE,
        NO_MIN_CLUSTER_SIZE;

    }
}

