/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.config.Config;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class StorageInfoCollector
implements MetricsCollector {
    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        Config config = node.getNodeEngine().getConfig();
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        boolean isHdEnabled = nativeMemoryConfig.isEnabled();
        metricsConsumer2.accept(PhoneHomeMetrics.HD_MEMORY_ENABLED, String.valueOf(isHdEnabled));
        if (isHdEnabled) {
            long offHeapMemorySize = node.getNodeExtension().getMemoryStats().getUsedNative();
            metricsConsumer2.accept(PhoneHomeMetrics.MEMORY_USED_NATIVE_SIZE, String.valueOf(offHeapMemorySize));
        }
        long usedHeap = node.getNodeExtension().getMemoryStats().getUsedHeap();
        metricsConsumer2.accept(PhoneHomeMetrics.MEMORY_USED_HEAP_SIZE, String.valueOf(usedHeap));
        boolean tieredStorageEnabled = config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        metricsConsumer2.accept(PhoneHomeMetrics.TIERED_STORAGE_ENABLED, String.valueOf(tieredStorageEnabled));
        MapService mapService = (MapService)node.getNodeEngine().getService("hz:impl:mapService");
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)node.getNodeEngine().getService("hz:impl:replicatedMapService");
        long totalEntryMemoryCost = Stream.concat(mapService.getStats().values().stream(), replicatedMapService.getStats().values().stream()).mapToLong(LocalMapStats::getOwnedEntryMemoryCost).sum();
        metricsConsumer2.accept(PhoneHomeMetrics.DATA_MEMORY_COST, String.valueOf(totalEntryMemoryCost));
    }
}

