/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.jobhistory.AMStarted;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMStartedEvent
implements HistoryEvent {
    private AMStarted datum = new AMStarted();
    private String forcedJobStateOnShutDown;
    private long submitTime;

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort, long submitTime) {
        this(appAttemptId, startTime, containerId, nodeManagerHost, nodeManagerPort, nodeManagerHttpPort, null, submitTime);
    }

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort, String forcedJobStateOnShutDown, long submitTime) {
        this.datum.setApplicationAttemptId(new Utf8(appAttemptId.toString()));
        this.datum.setStartTime(startTime);
        this.datum.setContainerId(new Utf8(containerId.toString()));
        this.datum.setNodeManagerHost(new Utf8(nodeManagerHost));
        this.datum.setNodeManagerPort(nodeManagerPort);
        this.datum.setNodeManagerHttpPort(nodeManagerHttpPort);
        this.forcedJobStateOnShutDown = forcedJobStateOnShutDown;
        this.submitTime = submitTime;
    }

    AMStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (AMStarted)datum;
    }

    public ApplicationAttemptId getAppAttemptId() {
        return ApplicationAttemptId.fromString(this.datum.getApplicationAttemptId().toString());
    }

    public long getStartTime() {
        return this.datum.getStartTime();
    }

    public ContainerId getContainerId() {
        return ContainerId.fromString(this.datum.getContainerId().toString());
    }

    public String getNodeManagerHost() {
        return this.datum.getNodeManagerHost().toString();
    }

    public int getNodeManagerPort() {
        return this.datum.getNodeManagerPort();
    }

    public int getNodeManagerHttpPort() {
        return this.datum.getNodeManagerHttpPort();
    }

    public String getForcedJobStateOnShutDown() {
        return this.forcedJobStateOnShutDown;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public EventType getEventType() {
        return EventType.AM_STARTED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("APPLICATION_ATTEMPT_ID", this.getAppAttemptId() == null ? "" : this.getAppAttemptId().toString());
        tEvent.addInfo("CONTAINER_ID", this.getContainerId() == null ? "" : this.getContainerId().toString());
        tEvent.addInfo("NODE_MANAGER_HOST", this.getNodeManagerHost());
        tEvent.addInfo("NODE_MANAGER_PORT", this.getNodeManagerPort());
        tEvent.addInfo("NODE_MANAGER_HTTP_PORT", this.getNodeManagerHttpPort());
        tEvent.addInfo("START_TIME", this.getStartTime());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

