/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.mapred.JobID;

class JVMId {
    boolean isMap;
    final JobID jobId;
    private long jvmId;
    private static final String JVM = "jvm";
    private static final char SEPARATOR = '_';
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public JVMId(JobID jobId, boolean isMap, long id) {
        this.jvmId = id;
        this.isMap = isMap;
        this.jobId = jobId;
    }

    public JVMId(String jtIdentifier, int jobId, boolean isMap, long id) {
        this(new JobID(jtIdentifier, jobId), isMap, id);
    }

    public JVMId() {
        this.jobId = new JobID();
    }

    public boolean isMapJVM() {
        return this.isMap;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JVMId jvmId1 = (JVMId)o;
        if (this.isMap != jvmId1.isMap) {
            return false;
        }
        if (this.jvmId != jvmId1.jvmId) {
            return false;
        }
        return this.jobId.equals(jvmId1.jobId);
    }

    public int hashCode() {
        int result = this.isMap ? 1 : 0;
        result = 31 * result + this.jobId.hashCode();
        result = 31 * result + (int)(this.jvmId ^ this.jvmId >>> 32);
        return result;
    }

    public int compareTo(JVMId that) {
        int jobComp = this.jobId.compareTo(that.jobId);
        if (jobComp == 0) {
            if (this.isMap == that.isMap) {
                return Long.compare(this.jvmId, that.jvmId);
            }
            return this.isMap ? -1 : 1;
        }
        return jobComp;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(JVM)).toString();
    }

    public long getId() {
        return this.jvmId;
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.jobId.appendTo(builder).append('_').append(this.isMap ? (char)'m' : 'r').append('_').append(idFormat.format(this.jvmId));
    }

    public void readFields(DataInput in) throws IOException {
        this.jvmId = in.readLong();
        this.jobId.readFields(in);
        this.isMap = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.jvmId);
        this.jobId.write(out);
        out.writeBoolean(this.isMap);
    }

    public static JVMId forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 5 && parts[0].equals(JVM)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new JVMId(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskId string : " + str + " is not properly formed");
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(6);
    }
}

