/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleMultipleRowStrategy
extends ShuffleStrategy {
    private static final Logger log = LoggerFactory.getLogger(ShuffleMultipleRowStrategy.class);
    private List<CatalogTable> catalogTables;
    private String targetTableId;

    public ShuffleMultipleRowStrategy() {
    }

    @Override
    public Map<String, IQueue<Record<?>>> createShuffles(HazelcastInstance hazelcast, int pipelineId, int inputIndex) {
        HashMap shuffleMap = new HashMap();
        for (CatalogTable entry : this.catalogTables) {
            String tableId = entry.getTableId().toTablePath().toString();
            String queueName = this.generateQueueName(pipelineId, inputIndex, tableId);
            IQueue<Record<?>> queue = this.getIQueue(hazelcast, queueName);
            queue.clear();
            shuffleMap.put(queueName, queue);
        }
        log.info("pipeline[{}] / reader[{}] assigned shuffle queue list: {}", pipelineId, inputIndex, shuffleMap.keySet());
        return shuffleMap;
    }

    @Override
    public String createShuffleKey(Record<?> record, int pipelineId, int inputIndex) {
        String tableId;
        if (record.getData() instanceof SeaTunnelRow) {
            tableId = ((SeaTunnelRow)record.getData()).getTableId();
        } else if (record.getData() instanceof SchemaChangeEvent) {
            tableId = ((SchemaChangeEvent)record.getData()).tablePath().toString();
        } else {
            throw new UnsupportedOperationException("Unsupported record: " + record);
        }
        return this.generateQueueName(pipelineId, inputIndex, tableId);
    }

    @Override
    public IQueue<Record<?>>[] getShuffles(HazelcastInstance hazelcast, int pipelineId, int targetIndex) {
        IQueue[] queues = new IQueue[this.getInputPartitions()];
        for (int inputIndex = 0; inputIndex < this.getInputPartitions(); ++inputIndex) {
            Objects.requireNonNull(this.targetTableId);
            String queueName = this.generateQueueName(pipelineId, inputIndex, this.targetTableId);
            queues[inputIndex] = this.getIQueue(hazelcast, queueName);
        }
        log.info("pipeline[{}] / writer[{}] assigned shuffle queue list: {}", pipelineId, targetIndex, Stream.of(queues).map(e -> e.getName()).collect(Collectors.toList()));
        return queues;
    }

    private String generateQueueName(int pipelineId, int inputIndex, String tableId) {
        return "ShuffleMultipleRow-Queue_" + this.getJobId() + "_" + pipelineId + "_" + inputIndex + "_" + tableId;
    }

    protected ShuffleMultipleRowStrategy(ShuffleMultipleRowStrategyBuilder<?, ?> b) {
        super(b);
        this.catalogTables = ((ShuffleMultipleRowStrategyBuilder)b).catalogTables;
        this.targetTableId = ((ShuffleMultipleRowStrategyBuilder)b).targetTableId;
    }

    public static ShuffleMultipleRowStrategyBuilder<?, ?> builder() {
        return new ShuffleMultipleRowStrategyBuilderImpl();
    }

    public ShuffleMultipleRowStrategyBuilder<?, ?> toBuilder() {
        return new ShuffleMultipleRowStrategyBuilderImpl().$fillValuesFrom(this);
    }

    public List<CatalogTable> getCatalogTables() {
        return this.catalogTables;
    }

    public String getTargetTableId() {
        return this.targetTableId;
    }

    public void setCatalogTables(List<CatalogTable> catalogTables) {
        this.catalogTables = catalogTables;
    }

    public void setTargetTableId(String targetTableId) {
        this.targetTableId = targetTableId;
    }

    @Override
    public String toString() {
        return "ShuffleMultipleRowStrategy(catalogTables=" + this.getCatalogTables() + ", targetTableId=" + this.getTargetTableId() + ")";
    }

    private static final class ShuffleMultipleRowStrategyBuilderImpl
    extends ShuffleMultipleRowStrategyBuilder<ShuffleMultipleRowStrategy, ShuffleMultipleRowStrategyBuilderImpl> {
        private ShuffleMultipleRowStrategyBuilderImpl() {
        }

        @Override
        protected ShuffleMultipleRowStrategyBuilderImpl self() {
            return this;
        }

        @Override
        public ShuffleMultipleRowStrategy build() {
            return new ShuffleMultipleRowStrategy(this);
        }
    }

    public static abstract class ShuffleMultipleRowStrategyBuilder<C extends ShuffleMultipleRowStrategy, B extends ShuffleMultipleRowStrategyBuilder<C, B>>
    extends ShuffleStrategy.ShuffleStrategyBuilder<C, B> {
        private List<CatalogTable> catalogTables;
        private String targetTableId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ShuffleMultipleRowStrategyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ShuffleMultipleRowStrategy instance, ShuffleMultipleRowStrategyBuilder<?, ?> b) {
            b.catalogTables(instance.catalogTables);
            b.targetTableId(instance.targetTableId);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B catalogTables(List<CatalogTable> catalogTables) {
            this.catalogTables = catalogTables;
            return (B)this.self();
        }

        public B targetTableId(String targetTableId) {
            this.targetTableId = targetTableId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ShuffleMultipleRowStrategy.ShuffleMultipleRowStrategyBuilder(super=" + super.toString() + ", catalogTables=" + this.catalogTables + ", targetTableId=" + this.targetTableId + ")";
        }
    }
}

