/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.InstanceCreationUtil;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ReflectiveCompactSerializer<T>
implements CompactSerializer<T> {
    private final Map<Class, Writer[]> writersCache = new ConcurrentHashMap<Class, Writer[]>();
    private final Map<Class, Reader[]> readersCache = new ConcurrentHashMap<Class, Reader[]>();

    @Override
    public void write(@Nonnull CompactWriter writer, @Nonnull T object) {
        Class<?> clazz = object.getClass();
        if (this.writeFast(clazz, writer, object)) {
            return;
        }
        this.createFastReadWriteCaches(clazz);
        this.writeFast(clazz, writer, object);
    }

    private boolean writeFast(Class clazz, CompactWriter compactWriter, Object object) {
        Writer[] writers = this.writersCache.get(clazz);
        if (writers == null) {
            return false;
        }
        for (Writer writer : writers) {
            try {
                writer.write(compactWriter, object);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
        }
        return true;
    }

    private boolean readFast(Class clazz, DefaultCompactReader compactReader, Object object) {
        Reader[] readers = this.readersCache.get(clazz);
        Schema schema = compactReader.getSchema();
        if (readers == null) {
            return false;
        }
        for (Reader reader : readers) {
            try {
                reader.read(compactReader, schema, object);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public T read(@Nonnull CompactReader reader) {
        Object object;
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = Objects.requireNonNull(compactReader.getAssociatedClass(), "AssociatedClass is required for ReflectiveCompactSerializer");
        if (this.readFast(associatedClass, compactReader, object = this.createObject(associatedClass))) {
            return (T)object;
        }
        this.createFastReadWriteCaches(associatedClass);
        this.readFast(associatedClass, compactReader, object);
        return (T)object;
    }

    @Nonnull
    private Object createObject(Class associatedClass) {
        try {
            return InstanceCreationUtil.createNewInstance(associatedClass);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Could not construct the class " + associatedClass, e);
        }
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.stream(type.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList()));
        if (type.getSuperclass() != null && type.getSuperclass() != Object.class) {
            ReflectiveCompactSerializer.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private boolean fieldExists(Schema schema, String name, FieldKind ... fieldKinds) {
        FieldDescriptor fieldDescriptor = schema.getField(name);
        if (fieldDescriptor == null) {
            return false;
        }
        for (FieldKind fieldKind : fieldKinds) {
            if (fieldDescriptor.getKind() != fieldKind) continue;
            return true;
        }
        return false;
    }

    private void createFastReadWriteCaches(Class clazz) {
        List<Field> allFields = ReflectiveCompactSerializer.getAllFields(new LinkedList<Field>(), clazz);
        Writer[] writers = new Writer[allFields.size()];
        Reader[] readers = new Reader[allFields.size()];
        int index = 0;
        for (Field field2 : allFields) {
            field2.setAccessible(true);
            Class<?> type = field2.getType();
            String name = field2.getName();
            if (Byte.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT8, FieldKind.NULLABLE_INT8)) {
                        field2.setByte(o, reader.readInt8(name));
                    }
                };
                writers[index] = (w, o) -> w.writeInt8(name, field2.getByte(o));
            } else if (Character.TYPE.equals(type)) {
                this.throwUnsupportedFieldTypeException("char");
            } else if (Short.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                        field2.setShort(o, reader.readInt16(name));
                    }
                };
                writers[index] = (w, o) -> w.writeInt16(name, field2.getShort(o));
            } else if (Integer.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT32, FieldKind.NULLABLE_INT32)) {
                        field2.setInt(o, reader.readInt32(name));
                    }
                };
                writers[index] = (w, o) -> w.writeInt32(name, field2.getInt(o));
            } else if (Long.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT64, FieldKind.NULLABLE_INT64)) {
                        field2.setLong(o, reader.readInt64(name));
                    }
                };
                writers[index] = (w, o) -> w.writeInt64(name, field2.getLong(o));
            } else if (Float.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32)) {
                        field2.setFloat(o, reader.readFloat32(name));
                    }
                };
                writers[index] = (w, o) -> w.writeFloat32(name, field2.getFloat(o));
            } else if (Double.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64)) {
                        field2.setDouble(o, reader.readFloat64(name));
                    }
                };
                writers[index] = (w, o) -> w.writeFloat64(name, field2.getDouble(o));
            } else if (Boolean.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN)) {
                        field2.setBoolean(o, reader.readBoolean(name));
                    }
                };
                writers[index] = (w, o) -> w.writeBoolean(name, field2.getBoolean(o));
            } else if (String.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.STRING)) {
                        field2.set(o, reader.readString(name));
                    }
                };
                writers[index] = (w, o) -> w.writeString(name, (String)field2.get(o));
            } else if (BigDecimal.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.DECIMAL)) {
                        field2.set(o, reader.readDecimal(name));
                    }
                };
                writers[index] = (w, o) -> w.writeDecimal(name, (BigDecimal)field2.get(o));
            } else if (LocalTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.TIME)) {
                        field2.set(o, reader.readTime(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTime(name, (LocalTime)field2.get(o));
            } else if (LocalDate.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.DATE)) {
                        field2.set(o, reader.readDate(name));
                    }
                };
                writers[index] = (w, o) -> w.writeDate(name, (LocalDate)field2.get(o));
            } else if (LocalDateTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.TIMESTAMP)) {
                        field2.set(o, reader.readTimestamp(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTimestamp(name, (LocalDateTime)field2.get(o));
            } else if (OffsetDateTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.TIMESTAMP_WITH_TIMEZONE)) {
                        field2.set(o, reader.readTimestampWithTimezone(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTimestampWithTimezone(name, (OffsetDateTime)field2.get(o));
            } else if (Byte.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT8, FieldKind.NULLABLE_INT8)) {
                        field2.set(o, reader.readNullableInt8(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableInt8(name, (Byte)field2.get(o));
            } else if (Character.class.equals(type)) {
                this.throwUnsupportedFieldTypeException("Character");
            } else if (Boolean.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN)) {
                        field2.set(o, reader.readNullableBoolean(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableBoolean(name, (Boolean)field2.get(o));
            } else if (Short.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT16, FieldKind.NULLABLE_INT16)) {
                        field2.set(o, reader.readNullableInt16(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableInt16(name, (Short)field2.get(o));
            } else if (Integer.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT32, FieldKind.NULLABLE_INT32)) {
                        field2.set(o, reader.readNullableInt32(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableInt32(name, (Integer)field2.get(o));
            } else if (Long.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.INT64, FieldKind.NULLABLE_INT64)) {
                        field2.set(o, reader.readNullableInt64(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableInt64(name, (Long)field2.get(o));
            } else if (Float.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32)) {
                        field2.set(o, reader.readNullableFloat32(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableFloat32(name, (Float)field2.get(o));
            } else if (Double.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64)) {
                        field2.set(o, reader.readNullableFloat64(name));
                    }
                };
                writers[index] = (w, o) -> w.writeNullableFloat64(name, (Double)field2.get(o));
            } else if (type.isEnum()) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.STRING)) {
                        String enumName = reader.readString(name);
                        field2.set(o, enumName == null ? null : Enum.valueOf(type, enumName));
                    }
                };
                writers[index] = (w, o) -> {
                    Object rawValue = field2.get(o);
                    String value = rawValue == null ? null : ((Enum)rawValue).name();
                    w.writeString(name, value);
                };
            } else if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (Boolean.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN)) {
                            field2.set(o, reader.readArrayOfBoolean(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfBoolean(name, (boolean[])field2.get(o));
                } else if (Byte.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8)) {
                            field2.set(o, reader.readArrayOfInt8(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfInt8(name, (byte[])field2.get(o));
                } else if (Character.TYPE.equals(componentType)) {
                    this.throwUnsupportedFieldTypeException("char[]");
                } else if (Short.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16)) {
                            field2.set(o, reader.readArrayOfInt16(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfInt16(name, (short[])field2.get(o));
                } else if (Integer.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32)) {
                            field2.set(o, reader.readArrayOfInt32(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfInt32(name, (int[])field2.get(o));
                } else if (Long.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64)) {
                            field2.set(o, reader.readArrayOfInt64(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfInt64(name, (long[])field2.get(o));
                } else if (Float.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32)) {
                            field2.set(o, reader.readArrayOfFloat32(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfFloat32(name, (float[])field2.get(o));
                } else if (Double.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64)) {
                            field2.set(o, reader.readArrayOfFloat64(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfFloat64(name, (double[])field2.get(o));
                } else if (Boolean.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN)) {
                            field2.set(o, reader.readArrayOfNullableBoolean(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableBoolean(name, (Boolean[])field2.get(o));
                } else if (Byte.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8)) {
                            field2.set(o, reader.readArrayOfNullableInt8(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableInt8(name, (Byte[])field2.get(o));
                } else if (Character.class.equals(componentType)) {
                    this.throwUnsupportedFieldTypeException("Character[]");
                } else if (Short.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16)) {
                            field2.set(o, reader.readArrayOfNullableInt16(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableInt16(name, (Short[])field2.get(o));
                } else if (Integer.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32)) {
                            field2.set(o, reader.readArrayOfNullableInt32(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableInt32(name, (Integer[])field2.get(o));
                } else if (Long.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64)) {
                            field2.set(o, reader.readArrayOfNullableInt64(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableInt64(name, (Long[])field2.get(o));
                } else if (Float.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32)) {
                            field2.set(o, reader.readArrayOfNullableFloat32(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableFloat32(name, (Float[])field2.get(o));
                } else if (Double.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64)) {
                            field2.set(o, reader.readArrayOfNullableFloat64(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfNullableFloat64(name, (Double[])field2.get(o));
                } else if (String.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_STRING)) {
                            field2.set(o, reader.readArrayOfString(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfString(name, (String[])field2.get(o));
                } else if (BigDecimal.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_DECIMAL)) {
                            field2.set(o, reader.readArrayOfDecimal(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfDecimal(name, (BigDecimal[])field2.get(o));
                } else if (LocalTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_TIME)) {
                            field2.set(o, reader.readArrayOfTime(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfTime(name, (LocalTime[])field2.get(o));
                } else if (LocalDate.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_DATE)) {
                            field2.set(o, reader.readArrayOfDate(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfDate(name, (LocalDate[])field2.get(o));
                } else if (LocalDateTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_TIMESTAMP)) {
                            field2.set(o, reader.readArrayOfTimestamp(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfTimestamp(name, (LocalDateTime[])field2.get(o));
                } else if (OffsetDateTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE)) {
                            field2.set(o, reader.readArrayOfTimestampWithTimezone(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfTimestampWithTimezone(name, (OffsetDateTime[])field2.get(o));
                } else if (componentType.isEnum()) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_STRING)) {
                            String[] stringArray = reader.readArrayOfString(name);
                            Enum[] enumArray = this.enumsFromString(componentType, stringArray);
                            field2.set(o, enumArray);
                        }
                    };
                    writers[index] = (w, o) -> {
                        Enum[] values = (Enum[])field2.get(o);
                        String[] stringArray = this.enumsAsStrings(values);
                        w.writeArrayOfString(name, stringArray);
                    };
                } else {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldKind.ARRAY_OF_COMPACT)) {
                            field2.set(o, reader.readArrayOfCompact(name, componentType));
                        }
                    };
                    writers[index] = (w, o) -> w.writeArrayOfCompact(name, (Object[])field2.get(o));
                }
            } else {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldKind.COMPACT)) {
                        field2.set(o, reader.readCompact(name));
                    }
                };
                writers[index] = (w, o) -> w.writeCompact(name, field2.get(o));
            }
            ++index;
        }
        this.writersCache.put(clazz, writers);
        this.readersCache.put(clazz, readers);
    }

    private String[] enumsAsStrings(Enum[] values) {
        String[] stringArray = null;
        if (values != null) {
            stringArray = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                stringArray[i] = values[i] == null ? null : values[i].name();
            }
        }
        return stringArray;
    }

    private Enum[] enumsFromString(Class<? extends Enum> componentType, String[] stringArray) {
        Enum[] enumArray = null;
        if (stringArray != null) {
            enumArray = new Enum[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                enumArray[i] = stringArray[i] == null ? null : Enum.valueOf(componentType, stringArray[i]);
            }
        }
        return enumArray;
    }

    private void throwUnsupportedFieldTypeException(String typeName) {
        throw new HazelcastSerializationException("Compact serialization format does not support fields of type '" + typeName + "'. If you want to use such fields with the compact serialization format, consider adding an explicit serializer for it.");
    }

    static interface Writer {
        public void write(CompactWriter var1, Object var2) throws Exception;
    }

    static interface Reader {
        public void read(CompactReader var1, Schema var2, Object var3) throws Exception;
    }
}

