/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportTransform;
import org.apache.seatunnel.transform.sql.SQLEngine;
import org.apache.seatunnel.transform.sql.SQLEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTransform
extends AbstractCatalogSupportTransform {
    private static final Logger log = LoggerFactory.getLogger(SQLTransform.class);
    public static final String PLUGIN_NAME = "Sql";
    public static final Option<String> KEY_QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("The query SQL");
    public static final Option<String> KEY_ENGINE = Options.key((String)"engine").stringType().defaultValue((Object)SQLEngineFactory.EngineType.ZETA.name()).withDescription("The SQL engine type");
    private final String query;
    private final SQLEngineFactory.EngineType engineType;
    private transient SQLEngine sqlEngine;

    public SQLTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.query = (String)config.get(KEY_QUERY);
        this.engineType = config.getOptional(KEY_ENGINE).isPresent() ? SQLEngineFactory.EngineType.valueOf(((String)config.get(KEY_ENGINE)).toUpperCase()) : SQLEngineFactory.EngineType.ZETA;
        List sourceTableNames = (List)config.get(CommonOptions.SOURCE_TABLE_NAME);
        this.inputTableName = sourceTableNames != null && !sourceTableNames.isEmpty() ? (String)sourceTableNames.get(0) : catalogTable.getTableId().getTableName();
        List columns = catalogTable.getTableSchema().getColumns();
        String[] fieldNames = new String[columns.size()];
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            fieldNames[i] = column.getName();
            fieldTypes[i] = column.getDataType();
        }
        this.inputRowType = new SeaTunnelRowType(fieldNames, fieldTypes);
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public void open() {
        this.sqlEngine = SQLEngineFactory.getSQLEngine(this.engineType);
        this.sqlEngine.init(this.inputTableName, this.inputCatalogTable != null ? this.inputCatalogTable.getTableId().getTableName() : null, this.inputRowType, this.query);
    }

    private void tryOpen() {
        if (this.sqlEngine == null) {
            this.open();
        }
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        this.tryOpen();
        return this.sqlEngine.transformBySQL(inputRow);
    }

    @Override
    protected TableSchema transformTableSchema() {
        this.tryOpen();
        ArrayList<String> inputColumnsMapping = new ArrayList<String>();
        SeaTunnelRowType outRowType = this.sqlEngine.typeMapping(inputColumnsMapping);
        List<String> outputColumns = Arrays.asList(outRowType.getFieldNames());
        TableSchema.Builder builder = TableSchema.builder();
        if (this.inputCatalogTable.getTableSchema().getPrimaryKey() != null && outputColumns.containsAll(this.inputCatalogTable.getTableSchema().getPrimaryKey().getColumnNames())) {
            builder.primaryKey(this.inputCatalogTable.getTableSchema().getPrimaryKey().copy());
        }
        List outputConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> {
            List constraintColumnNames = key.getColumnNames().stream().map(ConstraintKey.ConstraintKeyColumn::getColumnName).collect(Collectors.toList());
            return outputColumns.containsAll(constraintColumnNames);
        }).map(ConstraintKey::copy).collect(Collectors.toList());
        builder.constraintKey(outputConstraintKeys);
        String[] fieldNames = outRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = outRowType.getFieldTypes();
        ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            Column simpleColumn = null;
            String inputColumnName = (String)inputColumnsMapping.get(i);
            if (inputColumnName != null) {
                for (Column inputColumn : this.inputCatalogTable.getTableSchema().getColumns()) {
                    if (!inputColumnName.equals(inputColumn.getName())) continue;
                    simpleColumn = inputColumn;
                    break;
                }
            }
            PhysicalColumn column = simpleColumn != null ? new PhysicalColumn(fieldNames[i], fieldTypes[i], simpleColumn.getColumnLength(), simpleColumn.getScale(), simpleColumn.isNullable(), simpleColumn.getDefaultValue(), simpleColumn.getComment(), simpleColumn.getSourceType(), simpleColumn.getOptions()) : PhysicalColumn.of((String)fieldNames[i], (SeaTunnelDataType)fieldTypes[i], (Integer)0, (boolean)true, null, null);
            columns.add(column);
        }
        return builder.columns(columns).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    public void close() {
        this.sqlEngine.close();
    }
}

