/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DateTimeUtils {
    private static final Map<Formatter, DateTimeFormatter> FORMATTER_MAP = new HashMap<Formatter, DateTimeFormatter>();
    public static final Map<Pattern, DateTimeFormatter> YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP;
    public static Set<Map.Entry<Pattern, DateTimeFormatter>> YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP_ENTRY_SET;
    public static final Map<Pattern, DateTimeFormatter> YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP;
    public static Set<Map.Entry<Pattern, DateTimeFormatter>> YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP_ENTRY_SET;
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS_14_FORMATTER;

    public static DateTimeFormatter matchDateTimeFormatter(String dateTime) {
        if (dateTime.length() == 19) {
            for (Map.Entry<Pattern, DateTimeFormatter> entry : YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP_ENTRY_SET) {
                if (!entry.getKey().matcher(dateTime).matches()) continue;
                return entry.getValue();
            }
        } else if (dateTime.length() > 19) {
            for (Map.Entry<Pattern, DateTimeFormatter> entry : YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP_ENTRY_SET) {
                if (!entry.getKey().matcher(dateTime).matches()) continue;
                return entry.getValue();
            }
        } else if (dateTime.length() == 14) {
            return YYYY_MM_DD_HH_MM_SS_14_FORMATTER;
        }
        return null;
    }

    public static LocalDateTime parse(String dateTime, DateTimeFormatter dateTimeFormatter) {
        TemporalAccessor parsedTimestamp = dateTimeFormatter.parse(dateTime);
        LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
        LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
        return LocalDateTime.of(localDate, localTime);
    }

    public static LocalDateTime parse(String dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeUtils.matchDateTimeFormatter(dateTime);
        return LocalDateTime.parse(dateTime, dateTimeFormatter);
    }

    public static LocalDateTime parse(String dateTime, Formatter formatter) {
        return LocalDateTime.parse(dateTime, FORMATTER_MAP.get((Object)formatter));
    }

    public static LocalDateTime parse(long timestamp) {
        return DateTimeUtils.parse(timestamp, ZoneId.systemDefault());
    }

    public static LocalDateTime parse(long timestamp, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static String toString(LocalDateTime dateTime, Formatter formatter) {
        return dateTime.format(FORMATTER_MAP.get((Object)formatter));
    }

    public static String toString(long timestamp, Formatter formatter) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return DateTimeUtils.toString(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()), formatter);
    }

    static {
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSS, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSS.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SPOT, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SPOT.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SLASH, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SLASH.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_NO_SPLIT, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_NO_SPLIT.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_ISO8601, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_ISO8601.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SSS_ISO8601, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SSS_ISO8601.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSS_ISO8601, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSS_ISO8601.value));
        FORMATTER_MAP.put(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSSSSS_ISO8601, DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SSSSSSSSS_ISO8601.value));
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP = new LinkedHashMap<Pattern, DateTimeFormatter>();
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP_ENTRY_SET = new LinkedHashSet<Map.Entry<Pattern, DateTimeFormatter>>();
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP = new LinkedHashMap<Pattern, DateTimeFormatter>();
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP_ENTRY_SET = new LinkedHashSet<Map.Entry<Pattern, DateTimeFormatter>>();
        YYYY_MM_DD_HH_MM_SS_14_FORMATTER = DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_NO_SPLIT.value);
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}"), DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS.value));
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}.*"), new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter());
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}"), DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_ISO8601.value));
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.put(Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}.*"), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP.put(Pattern.compile("\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}"), DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SLASH.value));
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.put(Pattern.compile("\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}.*"), new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter()).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter());
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP.put(Pattern.compile("\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}:\\d{2}"), DateTimeFormatter.ofPattern(Formatter.YYYY_MM_DD_HH_MM_SS_SPOT.value));
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.put(Pattern.compile("\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}:\\d{2}.*"), new DateTimeFormatterBuilder().parseCaseInsensitive().append(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('.').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('.').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter()).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter());
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.put(Pattern.compile("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\s\\d{2}\u65f6\\d{2}\u5206\\d{2}\u79d2"), DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"));
        YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP_ENTRY_SET.addAll(YYYY_MM_DD_HH_MM_SS_19_FORMATTER_MAP.entrySet());
        YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP_ENTRY_SET.addAll(YYYY_MM_DD_HH_MM_SS_M19_FORMATTER_MAP.entrySet());
    }

    public static enum Formatter {
        YYYY_MM_DD_HH_MM_SS("yyyy-MM-dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SSSSSS("yyyy-MM-dd HH:mm:ss.SSSSSS"),
        YYYY_MM_DD_HH_MM_SS_SPOT("yyyy.MM.dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SLASH("yyyy/MM/dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_NO_SPLIT("yyyyMMddHHmmss"),
        YYYY_MM_DD_HH_MM_SS_ISO8601("yyyy-MM-dd'T'HH:mm:ss"),
        YYYY_MM_DD_HH_MM_SS_SSS_ISO8601("yyyy-MM-dd'T'HH:mm:ss.SSS"),
        YYYY_MM_DD_HH_MM_SS_SSSSSS_ISO8601("yyyy-MM-dd'T'HH:mm:ss.SSSSSS"),
        YYYY_MM_DD_HH_MM_SS_SSSSSSSSS_ISO8601("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");

        private final String value;

        private Formatter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Formatter parse(String format) {
            Formatter[] formatters;
            for (Formatter formatter : formatters = Formatter.values()) {
                if (!formatter.getValue().equals(format)) continue;
                return formatter;
            }
            String errorMsg = String.format("Illegal format [%s]", format);
            throw new IllegalArgumentException(errorMsg);
        }
    }
}

