/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.SerializerAdapter;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPool;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import java.io.IOException;
import java.util.Objects;

public class CompactWithSchemaStreamSerializerAdapter
implements SerializerAdapter {
    private final CompactStreamSerializer serializer;

    public CompactWithSchemaStreamSerializerAdapter(CompactStreamSerializer compactStreamSerializer) {
        this.serializer = compactStreamSerializer;
    }

    @Override
    public void write(ObjectDataOutput out, Object object) throws IOException {
        this.serializer.write((BufferObjectDataOutput)out, object, true);
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        return this.serializer.read((BufferObjectDataInput)in, true);
    }

    @Override
    public int getTypeId() {
        return -56;
    }

    @Override
    public void destroy() {
        this.serializer.destroy();
    }

    @Override
    public Serializer getImpl() {
        return this.serializer;
    }

    @Override
    public void conditionallyReturnInputBufferToPool(Object object, BufferObjectDataInput inputBuffer, BufferPool pool) {
        if (!(object instanceof DefaultCompactReader)) {
            pool.returnInputBuffer(inputBuffer);
        }
    }

    public String toString() {
        return "CompactWithSchemaStreamSerializerAdapter{serializer=" + this.serializer + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactWithSchemaStreamSerializerAdapter that = (CompactWithSchemaStreamSerializerAdapter)o;
        return Objects.equals(this.serializer, that.serializer);
    }

    public int hashCode() {
        return this.serializer != null ? this.serializer.hashCode() : 0;
    }
}

