/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.operation.GetClusterHealthMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobStatusOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private final Log4j2HttpGetCommandProcessor original;
    private static final String SOURCE_RECEIVED_COUNT = "SourceReceivedCount";
    private static final String SINK_WRITE_COUNT = "SinkWriteCount";
    private NodeEngine nodeEngine;

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
    }

    @Override
    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
                this.handleRunningJobsInfo(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/finished-jobs")) {
                this.handleFinishedJobsInfo(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-job")) {
                this.handleJobInfoById(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/system-monitoring-information")) {
                this.getSystemMonitoringInformation(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-threads")) {
                this.getRunningThread(httpGetCommand);
            } else {
                this.original.handle(httpGetCommand);
            }
        }
        catch (IndexOutOfBoundsException e) {
            httpGetCommand.send400();
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpGetCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse(e));
        }
        this.textCommandService.sendResponse(httpGetCommand);
    }

    @Override
    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    private void getSystemMonitoringInformation(HttpGetCommand command) {
        Cluster cluster = this.textCommandService.getNode().hazelcastInstance.getCluster();
        this.nodeEngine = this.textCommandService.getNode().hazelcastInstance.node.nodeEngine;
        Set<Member> members = cluster.getMembers();
        JsonArray jsonValues = members.stream().map(member -> {
            Address address = member.getAddress();
            String input = null;
            try {
                input = (String)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetClusterHealthMetricsOperation(), address).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("get system monitoring information fail", e);
            }
            String[] parts = input.split(", ");
            JsonObject jobInfo = new JsonObject();
            Arrays.stream(parts).forEach(part -> {
                String[] keyValue = part.split("=");
                jobInfo.add(keyValue[0], keyValue[1]);
            });
            return jobInfo;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jsonValues);
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        IMap values = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JsonArray jobs = values.entrySet().stream().map(jobInfoEntry -> this.convertToJson((JobInfo)jobInfoEntry.getValue(), (Long)jobInfoEntry.getKey())).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleFinishedJobsInfo(HttpGetCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash(uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        String state = indexEnd == -1 ? "" : uri.substring(indexEnd + 1);
        IMap finishedJob = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        IMap finishedJobMetrics = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics");
        IMap finishedJobDAGInfo = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo");
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        JsonArray jobs = finishedJob.values().stream().filter(jobState -> {
            if (state.isEmpty()) {
                return true;
            }
            return jobState.getJobStatus().name().equals(state.toUpperCase());
        }).sorted(Comparator.comparing(JobHistoryService.JobState::getFinishTime)).map(jobState -> {
            Long jobId = jobState.getJobId();
            String jobMetrics = seaTunnelServer == null ? (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join() : seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            return this.getJobInfoJson((JobHistoryService.JobState)jobState, jobMetrics, (JobDAGInfo)finishedJobDAGInfo.get(jobId));
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleJobInfoById(HttpGetCommand command, String uri) {
        uri = StringUtil.stripTrailingSlash(uri);
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String jobId = uri.substring(indexEnd + 1);
        JobInfo jobInfo = (JobInfo)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo").get(Long.valueOf(jobId));
        JobHistoryService.JobState finishedJobState = (JobHistoryService.JobState)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState").get(Long.valueOf(jobId));
        if (!jobId.isEmpty() && jobInfo != null) {
            this.prepareResponse(command, this.convertToJson(jobInfo, Long.parseLong(jobId)));
        } else if (!jobId.isEmpty() && finishedJobState != null) {
            JobMetrics finishedJobMetrics = (JobMetrics)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics").get(Long.valueOf(jobId));
            JobDAGInfo finishedJobDAGInfo = (JobDAGInfo)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo").get(Long.valueOf(jobId));
            this.prepareResponse(command, this.getJobInfoJson(finishedJobState, finishedJobMetrics.toJsonString(), finishedJobDAGInfo));
        } else {
            this.prepareResponse(command, new JsonObject().add("jobId", jobId));
        }
    }

    private void getRunningThread(HttpGetCommand command) {
        this.prepareResponse(command, Thread.getAllStackTraces().keySet().stream().sorted(Comparator.comparing(Thread::getName)).map(stackTraceElements -> {
            JsonObject jobInfoJson = new JsonObject();
            jobInfoJson.add("threadName", stackTraceElements.getName());
            jobInfoJson.add("classLoader", String.valueOf(stackTraceElements.getContextClassLoader()));
            return jobInfoJson;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add));
    }

    private Map<String, Long> getJobMetrics(String jobMetrics) {
        HashMap<String, Long> metricsMap = new HashMap<String, Long>();
        long sourceReadCount = 0L;
        long sinkWriteCount = 0L;
        try {
            JsonNode jobMetricsStr = new ObjectMapper().readTree(jobMetrics);
            JsonNode sourceReceivedCountJson = jobMetricsStr.get(SOURCE_RECEIVED_COUNT);
            JsonNode sinkWriteCountJson = jobMetricsStr.get(SINK_WRITE_COUNT);
            for (int i = 0; i < jobMetricsStr.get(SOURCE_RECEIVED_COUNT).size(); ++i) {
                JsonNode sourceReader = sourceReceivedCountJson.get(i);
                JsonNode sinkWriter = sinkWriteCountJson.get(i);
                sourceReadCount += sourceReader.get("value").asLong();
                sinkWriteCount += sinkWriter.get("value").asLong();
            }
        }
        catch (NullPointerException | JsonProcessingException e) {
            return metricsMap;
        }
        metricsMap.put(SOURCE_RECEIVED_COUNT, sourceReadCount);
        metricsMap.put(SINK_WRITE_COUNT, sinkWriteCount);
        return metricsMap;
    }

    private SeaTunnelServer getSeaTunnelServer(boolean shouldBeMaster) {
        Map<String, Object> extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        if (shouldBeMaster && !seaTunnelServer.isMasterNode()) {
            return null;
        }
        return seaTunnelServer;
    }

    private JsonObject convertToJson(JobInfo jobInfo, long jobId) {
        JobStatus jobStatus;
        String jobMetrics;
        JsonObject jobInfoJson = new JsonObject();
        JobImmutableInformation jobImmutableInformation = (JobImmutableInformation)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(jobInfo.getJobImmutableInformation()));
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer(true);
        ClassLoaderService classLoaderService = seaTunnelServer == null ? this.getSeaTunnelServer(false).getClassLoaderService() : seaTunnelServer.getClassLoaderService();
        ClassLoader classLoader = classLoaderService.getClassLoader(jobId, jobImmutableInformation.getPluginJarsUrls());
        LogicalDag logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.textCommandService.getNode().getNodeEngine().getSerializationService(), classLoader, jobImmutableInformation.getLogicalDag());
        classLoaderService.releaseClassLoader(jobId, jobImmutableInformation.getPluginJarsUrls());
        if (seaTunnelServer == null) {
            jobMetrics = (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join();
            jobStatus = JobStatus.values()[(Integer)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobStatusOperation(jobId)).join()];
        } else {
            jobMetrics = seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            jobStatus = seaTunnelServer.getCoordinatorService().getJobStatus(jobId);
        }
        jobInfoJson.add("jobId", String.valueOf(jobId)).add("jobName", logicalDag.getJobConfig().getName()).add("jobStatus", jobStatus.toString()).add("envOptions", JsonUtil.toJsonObject(logicalDag.getJobConfig().getEnvOptions())).add("createTime", DateTimeUtils.toString(jobImmutableInformation.getCreateTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", logicalDag.getLogicalDagAsJson()).add("pluginJarsUrls", jobImmutableInformation.getPluginJarsUrls().stream().map(url -> {
            JsonObject jarUrl = new JsonObject();
            jarUrl.add("jarPath", url.toString());
            return jarUrl;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add)).add("isStartWithSavePoint", jobImmutableInformation.isStartWithSavePoint()).add("metrics", JsonUtil.toJsonObject(this.getJobMetrics(jobMetrics)));
        return jobInfoJson;
    }

    private JsonObject getJobInfoJson(JobHistoryService.JobState jobState, String jobMetrics, JobDAGInfo jobDAGInfo) {
        return new JsonObject().add("jobId", String.valueOf(jobState.getJobId())).add("jobName", jobState.getJobName()).add("jobStatus", jobState.getJobStatus().toString()).add("errorMsg", jobState.getErrorMessage()).add("createTime", DateTimeUtils.toString(jobState.getSubmitTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("finishTime", DateTimeUtils.toString(jobState.getFinishTime(), DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)).add("jobDag", JsonUtils.toJsonString(jobDAGInfo)).add("pluginJarsUrls", new JsonArray()).add("metrics", JsonUtil.toJsonObject(this.getJobMetrics(jobMetrics)));
    }
}

