/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.logging.ILogger;
import java.util.function.Consumer;

public final class PacketDispatcher
implements Consumer<Packet> {
    private final ILogger logger;
    private final Consumer<Packet> eventService;
    private final Consumer<Packet> operationExecutor;
    private final Consumer<Packet> jetServiceBackend;
    private final Consumer<Packet> responseHandler;
    private final Consumer<Packet> invocationMonitor;

    public PacketDispatcher(ILogger logger, Consumer<Packet> operationExecutor, Consumer<Packet> responseHandler, Consumer<Packet> invocationMonitor, Consumer<Packet> eventService, Consumer<Packet> jetServiceBackend) {
        this.logger = logger;
        this.responseHandler = responseHandler;
        this.eventService = eventService;
        this.invocationMonitor = invocationMonitor;
        this.operationExecutor = operationExecutor;
        this.jetServiceBackend = jetServiceBackend;
    }

    @Override
    public void accept(Packet packet) {
        try {
            switch (packet.getPacketType()) {
                case OPERATION: {
                    if (packet.isFlagRaised(2)) {
                        this.responseHandler.accept(packet);
                        break;
                    }
                    if (packet.isFlagRaised(64)) {
                        this.invocationMonitor.accept(packet);
                        break;
                    }
                    this.operationExecutor.accept(packet);
                    break;
                }
                case EVENT: {
                    this.eventService.accept(packet);
                    break;
                }
                case SERVER_CONTROL: {
                    ServerConnection connection = packet.getConn();
                    ServerConnectionManager connectionManager = connection.getConnectionManager();
                    connectionManager.accept(packet);
                    break;
                }
                case JET: {
                    this.jetServiceBackend.accept(packet);
                    break;
                }
                default: {
                    this.logger.severe("Header flags [" + Integer.toBinaryString(packet.getFlags()) + "] specify an undefined packet type " + packet.getPacketType().name());
                    break;
                }
            }
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            this.logger.severe("Failed to process: " + packet, t);
        }
    }
}

