/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.api.table.event;

import org.apache.seatunnel.api.table.catalog.TablePath;

import lombok.Getter;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

@Getter
@ToString(callSuper = true)
public class AlterTableColumnsEvent extends AlterTableEvent {
    private final List<AlterTableColumnEvent> events;

    public AlterTableColumnsEvent(TablePath tablePath) {
        this(tablePath, new ArrayList<>());
    }

    public AlterTableColumnsEvent(TablePath tablePath, List<AlterTableColumnEvent> events) {
        super(tablePath);
        this.events = events;
    }

    public AlterTableColumnsEvent addEvent(AlterTableColumnEvent event) {
        events.add(event);
        return this;
    }
}
