/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.engine.core.dag.actions.TransformChainAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformFlowLifeCycle<T>
extends ActionFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>> {
    private static final Logger log = LoggerFactory.getLogger(TransformFlowLifeCycle.class);
    private final TransformChainAction<T> action;
    private final List<SeaTunnelTransform<T>> transform;
    private final Collector<Record<?>> collector;

    public TransformFlowLifeCycle(TransformChainAction<T> action, SeaTunnelTask runningTask, Collector<Record<?>> collector, CompletableFuture<Void> completableFuture) {
        super(action, runningTask, completableFuture);
        this.action = action;
        this.transform = action.getTransforms();
        this.collector = collector;
    }

    @Override
    public void open() throws Exception {
        super.open();
        for (SeaTunnelTransform<T> t : this.transform) {
            try {
                t.open();
            }
            catch (Exception e) {
                log.error("Open transform: {} failed, cause: {}", t.getPluginName(), e.getMessage(), e);
            }
        }
    }

    @Override
    public void received(Record<?> record) {
        if (record.getData() instanceof Barrier) {
            CheckpointBarrier barrier = (CheckpointBarrier)record.getData();
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            if (barrier.snapshot()) {
                this.runningTask.addState(barrier, ActionStateKey.of(this.action), Collections.emptyList());
            }
            this.runningTask.ack(barrier);
            this.collector.collect(record);
        } else {
            Object inputData;
            if (this.prepareClose.booleanValue()) {
                return;
            }
            Object outputData = inputData = record.getData();
            for (SeaTunnelTransform<?> seaTunnelTransform : this.transform) {
                outputData = seaTunnelTransform.map(inputData);
                log.debug("Transform[{}] input row {} and output row {}", seaTunnelTransform, inputData, outputData);
                if (outputData == null) {
                    log.trace("Transform[{}] filtered data row {}", (Object)seaTunnelTransform, inputData);
                    break;
                }
                inputData = outputData;
            }
            if (outputData != null) {
                this.collector.collect(new Record(outputData));
            }
        }
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
    }

    @Override
    public void close() throws IOException {
        for (SeaTunnelTransform<T> t : this.transform) {
            try {
                t.close();
            }
            catch (Exception e) {
                log.error("Close transform: {} failed, cause: {}", t.getPluginName(), e.getMessage(), e);
            }
        }
        super.close();
    }
}

