/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.operation.GetClusterHealthMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobMetricsOperation;
import org.apache.seatunnel.engine.server.operation.GetJobStatusOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class RestHttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private final Log4j2HttpGetCommandProcessor original;
    private static final String SOURCE_RECEIVED_COUNT = "SourceReceivedCount";
    private static final String SINK_WRITE_COUNT = "SinkWriteCount";
    private NodeEngine nodeEngine;

    public RestHttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpGetCommandProcessor(textCommandService));
    }

    public RestHttpGetCommandProcessor(TextCommandService textCommandService, Log4j2HttpGetCommandProcessor log4j2HttpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = log4j2HttpGetCommandProcessor;
    }

    @Override
    public void handle(HttpGetCommand httpGetCommand) {
        String uri = httpGetCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/running-jobs")) {
                this.handleRunningJobsInfo(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/finished-jobs")) {
                this.handleFinishedJobsInfo(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-job")) {
                this.handleJobInfoById(httpGetCommand, uri);
            } else if (uri.startsWith("/hazelcast/rest/maps/system-monitoring-information")) {
                this.getSystemMonitoringInformation(httpGetCommand);
            } else if (uri.startsWith("/hazelcast/rest/maps/running-threads")) {
                this.getRunningThread(httpGetCommand);
            } else {
                this.original.handle(httpGetCommand);
            }
        }
        catch (IndexOutOfBoundsException e) {
            httpGetCommand.send400();
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpGetCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, httpGetCommand, RestHttpGetCommandProcessor.exceptionResponse(e));
        }
        this.textCommandService.sendResponse(httpGetCommand);
    }

    @Override
    public void handleRejection(HttpGetCommand httpGetCommand) {
        this.handle(httpGetCommand);
    }

    private void getSystemMonitoringInformation(HttpGetCommand command) {
        Cluster cluster = this.textCommandService.getNode().hazelcastInstance.getCluster();
        this.nodeEngine = this.textCommandService.getNode().hazelcastInstance.node.nodeEngine;
        Set<Member> members = cluster.getMembers();
        JsonArray jsonValues = members.stream().map(member -> {
            Address address = member.getAddress();
            String input = null;
            try {
                input = (String)NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, new GetClusterHealthMetricsOperation(), address).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("get system monitoring information fail", e);
            }
            String[] parts = input.split(", ");
            JsonObject jobInfo = new JsonObject();
            Arrays.stream(parts).forEach(part -> {
                String[] keyValue = part.split("=");
                jobInfo.add(keyValue[0], keyValue[1]);
            });
            return jobInfo;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jsonValues);
    }

    private void handleRunningJobsInfo(HttpGetCommand command) {
        IMap values = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo");
        JsonArray jobs = values.entrySet().stream().map(jobInfoEntry -> this.convertToJson((JobInfo)jobInfoEntry.getValue(), (Long)jobInfoEntry.getKey())).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleFinishedJobsInfo(HttpGetCommand command, String uri) {
        int indexEnd = (uri = StringUtil.stripTrailingSlash(uri)).indexOf(47, "/hazelcast/rest/maps/".length());
        String state = indexEnd == -1 ? "" : uri.substring(indexEnd + 1);
        IMap finishedJob = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobState");
        IMap finishedJobMetrics = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobMetrics");
        IMap finishedJobDAGInfo = this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_finishedJobVertexInfo");
        JsonArray jobs = finishedJob.values().stream().filter(jobState -> {
            if (state.isEmpty()) {
                return true;
            }
            return jobState.getJobStatus().name().equals(state.toUpperCase());
        }).sorted(Comparator.comparing(JobHistoryService.JobState::getFinishTime)).map(jobState -> {
            Long jobId = jobState.getJobId();
            SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer();
            String jobMetrics = seaTunnelServer == null ? (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join() : seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            JobDAGInfo jobDAGInfo = (JobDAGInfo)finishedJobDAGInfo.get(jobId);
            return this.convertToJson((JobHistoryService.JobState)jobState, jobMetrics, Json.parse(JsonUtils.toJsonString(jobDAGInfo)).asObject(), jobId);
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add);
        this.prepareResponse(command, jobs);
    }

    private void handleJobInfoById(HttpGetCommand command, String uri) {
        uri = StringUtil.stripTrailingSlash(uri);
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String jobId = uri.substring(indexEnd + 1);
        JobInfo jobInfo = (JobInfo)this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getMap("engine_runningJobInfo").get(Long.valueOf(jobId));
        if (!jobId.isEmpty() && jobInfo != null) {
            this.prepareResponse(command, this.convertToJson(jobInfo, Long.parseLong(jobId)));
        } else {
            this.prepareResponse(command, new JsonObject());
        }
    }

    private void getRunningThread(HttpGetCommand command) {
        this.prepareResponse(command, Thread.getAllStackTraces().keySet().stream().sorted(Comparator.comparing(Thread::getName)).map(stackTraceElements -> {
            JsonObject jobInfoJson = new JsonObject();
            jobInfoJson.add("threadName", stackTraceElements.getName());
            jobInfoJson.add("classLoader", String.valueOf(stackTraceElements.getContextClassLoader()));
            return jobInfoJson;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add));
    }

    private Map<String, Long> getJobMetrics(String jobMetrics) {
        HashMap<String, Long> metricsMap = new HashMap<String, Long>();
        long sourceReadCount = 0L;
        long sinkWriteCount = 0L;
        try {
            JsonNode jobMetricsStr = new ObjectMapper().readTree(jobMetrics);
            JsonNode sourceReceivedCountJson = jobMetricsStr.get(SOURCE_RECEIVED_COUNT);
            JsonNode sinkWriteCountJson = jobMetricsStr.get(SINK_WRITE_COUNT);
            for (int i = 0; i < jobMetricsStr.get(SOURCE_RECEIVED_COUNT).size(); ++i) {
                JsonNode sourceReader = sourceReceivedCountJson.get(i);
                JsonNode sinkWriter = sinkWriteCountJson.get(i);
                sourceReadCount += sourceReader.get("value").asLong();
                sinkWriteCount += sinkWriter.get("value").asLong();
            }
        }
        catch (NullPointerException | JsonProcessingException e) {
            return metricsMap;
        }
        metricsMap.put(SOURCE_RECEIVED_COUNT, sourceReadCount);
        metricsMap.put(SINK_WRITE_COUNT, sinkWriteCount);
        return metricsMap;
    }

    private SeaTunnelServer getSeaTunnelServer() {
        Map<String, Object> extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
        if (!seaTunnelServer.isMasterNode()) {
            return null;
        }
        return seaTunnelServer;
    }

    private JsonObject convertToJson(JobInfo jobInfo, long jobId) {
        JobStatus jobStatus;
        String jobMetrics;
        JsonObject jobInfoJson = new JsonObject();
        JobImmutableInformation jobImmutableInformation = (JobImmutableInformation)this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(this.textCommandService.getNode().getNodeEngine().getSerializationService().toObject(jobInfo.getJobImmutableInformation()));
        SeaTunnelChildFirstClassLoader classLoader = new SeaTunnelChildFirstClassLoader(jobImmutableInformation.getPluginJarsUrls());
        LogicalDag logicalDag = (LogicalDag)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.textCommandService.getNode().getNodeEngine().getSerializationService(), classLoader, jobImmutableInformation.getLogicalDag());
        SeaTunnelServer seaTunnelServer = this.getSeaTunnelServer();
        if (seaTunnelServer == null) {
            jobMetrics = (String)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobMetricsOperation(jobId)).join();
            jobStatus = JobStatus.values()[(Integer)NodeEngineUtil.sendOperationToMasterNode(this.getNode().nodeEngine, new GetJobStatusOperation(jobId)).join()];
        } else {
            jobMetrics = seaTunnelServer.getCoordinatorService().getJobMetrics(jobId).toJsonString();
            jobStatus = seaTunnelServer.getCoordinatorService().getJobStatus(jobId);
        }
        jobInfoJson.add("jobId", String.valueOf(jobId)).add("jobName", logicalDag.getJobConfig().getName()).add("jobStatus", jobStatus.toString()).add("envOptions", JsonUtil.toJsonObject(logicalDag.getJobConfig().getEnvOptions())).add("createTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(jobImmutableInformation.getCreateTime()))).add("jobDag", logicalDag.getLogicalDagAsJson()).add("pluginJarsUrls", jobImmutableInformation.getPluginJarsUrls().stream().map(url -> {
            JsonObject jarUrl = new JsonObject();
            jarUrl.add("jarPath", url.toString());
            return jarUrl;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::add)).add("isStartWithSavePoint", jobImmutableInformation.isStartWithSavePoint()).add("metrics", JsonUtil.toJsonObject(this.getJobMetrics(jobMetrics)));
        return jobInfoJson;
    }

    private JsonObject convertToJson(JobHistoryService.JobState jobState, String jobMetrics, JsonObject jobDAGInfo, long jobId) {
        JsonObject jobInfoJson = new JsonObject();
        jobInfoJson.add("jobId", String.valueOf(jobId)).add("jobName", jobState.getJobName()).add("jobStatus", jobState.getJobStatus().toString()).add("errorMsg", jobState.getErrorMessage()).add("createTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(jobState.getSubmitTime()))).add("finishTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(jobState.getFinishTime()))).add("jobDag", jobDAGInfo).add("metrics", JsonUtil.toJsonObject(this.getJobMetrics(jobMetrics)));
        return jobInfoJson;
    }
}

