/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.scheduledexecutor.impl.AbstractScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.PartitionCapacityPermit;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.ReplicationOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Iterator;
import java.util.Map;

public class ScheduledExecutorPartition
extends AbstractScheduledExecutorContainerHolder {
    private final int partitionId;
    private final ILogger logger;
    private final ConstructorFunction<String, ScheduledExecutorContainer> containerConstructorFunction;

    ScheduledExecutorPartition(NodeEngine nodeEngine, DistributedScheduledExecutorService service, int partitionId) {
        super(nodeEngine);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.partitionId = partitionId;
        this.containerConstructorFunction = name -> {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("[Partition:" + partitionId + "]Create new scheduled executor container with name:" + name);
            }
            ScheduledExecutorConfig config = nodeEngine.getConfig().findScheduledExecutorConfig((String)name);
            return new ScheduledExecutorContainer((String)name, partitionId, nodeEngine, this.newPermitFor((String)name, service, config), config.getDurability(), config.isStatisticsEnabled());
        };
    }

    public Operation prepareReplicationOperation(int replicaIndex) {
        Map<String, Map<String, ScheduledTaskDescriptor>> map = MapUtil.createHashMap(this.containers.size());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Partition: " + this.partitionId + "] Preparing replication for index: " + replicaIndex);
        }
        for (ScheduledExecutorContainer container : this.containers.values()) {
            if (replicaIndex > container.getDurability()) continue;
            map.put(container.getName(), container.prepareForReplication());
        }
        return map.isEmpty() ? null : new ReplicationOperation(map);
    }

    @Override
    public ConstructorFunction<String, ScheduledExecutorContainer> getContainerConstructorFunction() {
        return this.containerConstructorFunction;
    }

    CapacityPermit newPermitFor(String name, DistributedScheduledExecutorService service, ScheduledExecutorConfig config) {
        if (config.getCapacity() == 0) {
            return DistributedScheduledExecutorService.NOOP_PERMIT;
        }
        return config.getCapacityPolicy() == ScheduledExecutorConfig.CapacityPolicy.PER_PARTITION ? new PartitionCapacityPermit(name, config.getCapacity(), this.partitionId) : service.permitFor(name, config);
    }

    void disposeObsoleteReplicas(int thresholdReplicaIndex) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Partition: " + this.partitionId + "] Dispose obsolete replicas with thresholdReplicaIndex: " + thresholdReplicaIndex);
        }
        if (thresholdReplicaIndex < 0) {
            for (ScheduledExecutorContainer container : this.containers.values()) {
                container.destroy();
            }
            this.containers.clear();
        } else {
            Iterator iterator = this.containers.values().iterator();
            while (iterator.hasNext()) {
                ScheduledExecutorContainer container = (ScheduledExecutorContainer)iterator.next();
                if (thresholdReplicaIndex <= container.getDurability()) continue;
                container.destroy();
                iterator.remove();
            }
        }
    }

    void promoteSuspended() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Partition: " + this.partitionId + "] Promote suspended");
        }
        for (ScheduledExecutorContainer container : this.containers.values()) {
            container.promoteSuspended();
        }
    }

    void suspendTasks() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Partition: " + this.partitionId + "] Suspending tasks");
        }
        for (ScheduledExecutorContainer container : this.containers.values()) {
            container.suspendTasks();
        }
    }
}

