/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.bloom.RemoveScheme;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class RetouchedBloomFilter
extends BloomFilter
implements RemoveScheme {
    List<Key>[] fpVector;
    List<Key>[] keyVector;
    double[] ratio;
    private Random rand;

    public RetouchedBloomFilter() {
    }

    public RetouchedBloomFilter(int vectorSize, int nbHash, int hashType) {
        super(vectorSize, nbHash, hashType);
        this.rand = null;
        this.createVector();
    }

    @Override
    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        int[] h2 = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            this.bits.set(h2[i]);
            this.keyVector[h2[i]].add(key);
        }
    }

    public void addFalsePositive(Key key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        int[] h2 = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            this.fpVector[h2[i]].add(key);
        }
    }

    public void addFalsePositive(Collection<Key> coll) {
        if (coll == null) {
            throw new NullPointerException("Collection<Key> can not be null");
        }
        for (Key k : coll) {
            this.addFalsePositive(k);
        }
    }

    public void addFalsePositive(List<Key> keys) {
        if (keys == null) {
            throw new NullPointerException("ArrayList<Key> can not be null");
        }
        for (Key k : keys) {
            this.addFalsePositive(k);
        }
    }

    public void addFalsePositive(Key[] keys) {
        if (keys == null) {
            throw new NullPointerException("Key[] can not be null");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.addFalsePositive(keys[i]);
        }
    }

    public void selectiveClearing(Key k, short scheme) {
        if (k == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (!this.membershipTest(k)) {
            throw new IllegalArgumentException("Key is not a member");
        }
        int index = 0;
        int[] h2 = this.hash.hash(k);
        switch (scheme) {
            case 0: {
                index = this.randomRemove();
                break;
            }
            case 1: {
                index = this.minimumFnRemove(h2);
                break;
            }
            case 2: {
                index = this.maximumFpRemove(h2);
                break;
            }
            case 3: {
                index = this.ratioRemove(h2);
                break;
            }
            default: {
                throw new AssertionError((Object)"Undefined selective clearing scheme");
            }
        }
        this.clearBit(index);
    }

    private int randomRemove() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand.nextInt(this.nbHash);
    }

    private int minimumFnRemove(int[] h2) {
        int minIndex = Integer.MAX_VALUE;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < this.nbHash; ++i) {
            double keyWeight = this.getWeight(this.keyVector[h2[i]]);
            if (!(keyWeight < minValue)) continue;
            minIndex = h2[i];
            minValue = keyWeight;
        }
        return minIndex;
    }

    private int maximumFpRemove(int[] h2) {
        int maxIndex = Integer.MIN_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < this.nbHash; ++i) {
            double fpWeight = this.getWeight(this.fpVector[h2[i]]);
            if (!(fpWeight > maxValue)) continue;
            maxValue = fpWeight;
            maxIndex = h2[i];
        }
        return maxIndex;
    }

    private int ratioRemove(int[] h2) {
        this.computeRatio();
        int minIndex = Integer.MAX_VALUE;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < this.nbHash; ++i) {
            if (!(this.ratio[h2[i]] < minValue)) continue;
            minValue = this.ratio[h2[i]];
            minIndex = h2[i];
        }
        return minIndex;
    }

    private void clearBit(int index) {
        int i;
        if (index < 0 || index >= this.vectorSize) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        List<Key> kl = this.keyVector[index];
        List<Key> fpl = this.fpVector[index];
        int listSize = kl.size();
        for (i = 0; i < listSize && !kl.isEmpty(); ++i) {
            this.removeKey(kl.get(0), this.keyVector);
        }
        kl.clear();
        this.keyVector[index].clear();
        listSize = fpl.size();
        for (i = 0; i < listSize && !fpl.isEmpty(); ++i) {
            this.removeKey(fpl.get(0), this.fpVector);
        }
        fpl.clear();
        this.fpVector[index].clear();
        this.ratio[index] = 0.0;
        this.bits.clear(index);
    }

    private void removeKey(Key k, List<Key>[] vector) {
        if (k == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (vector == null) {
            throw new NullPointerException("ArrayList<Key>[] can not be null");
        }
        int[] h2 = this.hash.hash(k);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            vector[h2[i]].remove(k);
        }
    }

    private void computeRatio() {
        for (int i = 0; i < this.vectorSize; ++i) {
            double keyWeight = this.getWeight(this.keyVector[i]);
            double fpWeight = this.getWeight(this.fpVector[i]);
            if (!(keyWeight > 0.0) || !(fpWeight > 0.0)) continue;
            this.ratio[i] = keyWeight / fpWeight;
        }
    }

    private double getWeight(List<Key> keyList) {
        double weight = 0.0;
        for (Key k : keyList) {
            weight += k.getWeight();
        }
        return weight;
    }

    private void createVector() {
        this.fpVector = new List[this.vectorSize];
        this.keyVector = new List[this.vectorSize];
        this.ratio = new double[this.vectorSize];
        for (int i = 0; i < this.vectorSize; ++i) {
            this.fpVector[i] = Collections.synchronizedList(new ArrayList());
            this.keyVector[i] = Collections.synchronizedList(new ArrayList());
            this.ratio[i] = 0.0;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        List<Key> list;
        int i;
        super.write(out);
        for (i = 0; i < this.fpVector.length; ++i) {
            list = this.fpVector[i];
            out.writeInt(list.size());
            for (Key k : list) {
                k.write(out);
            }
        }
        for (i = 0; i < this.keyVector.length; ++i) {
            list = this.keyVector[i];
            out.writeInt(list.size());
            for (Key k : list) {
                k.write(out);
            }
        }
        for (i = 0; i < this.ratio.length; ++i) {
            out.writeDouble(this.ratio[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Key k;
        int j;
        int size;
        List<Key> list;
        int i;
        super.readFields(in);
        this.createVector();
        for (i = 0; i < this.fpVector.length; ++i) {
            list = this.fpVector[i];
            size = in.readInt();
            for (j = 0; j < size; ++j) {
                k = new Key();
                k.readFields(in);
                list.add(k);
            }
        }
        for (i = 0; i < this.keyVector.length; ++i) {
            list = this.keyVector[i];
            size = in.readInt();
            for (j = 0; j < size; ++j) {
                k = new Key();
                k.readFields(in);
                list.add(k);
            }
        }
        for (i = 0; i < this.ratio.length; ++i) {
            this.ratio[i] = in.readDouble();
        }
    }
}

