/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.PluginIdentifierInterface;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.common.utils.ReflectionUtils;
import org.apache.seatunnel.plugin.discovery.PluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginDiscovery<T>
implements PluginDiscovery<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginDiscovery.class);
    private static final String PLUGIN_MAPPING_FILE = "plugin-mapping.properties";
    private static final BiConsumer<ClassLoader, URL> DEFAULT_URL_TO_CLASSLOADER = (classLoader, url) -> {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new UnsupportedOperationException("can't support custom load jar");
        }
        ReflectionUtils.invoke(classLoader, "addURL", url);
    };
    private final Path pluginDir;
    private final Config pluginConfig;
    private final BiConsumer<ClassLoader, URL> addURLToClassLoaderConsumer;
    protected final ConcurrentHashMap<PluginIdentifier, Optional<URL>> pluginJarPath = new ConcurrentHashMap(16);

    public AbstractPluginDiscovery(String pluginSubDir, BiConsumer<ClassLoader, URL> addURLToClassloader) {
        this(Common.connectorJarDir(pluginSubDir), AbstractPluginDiscovery.loadConnectorPluginConfig(), addURLToClassloader);
    }

    public AbstractPluginDiscovery(String pluginSubDir) {
        this(Common.connectorJarDir(pluginSubDir), AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir) {
        this(pluginDir, AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginConfig) {
        this(pluginDir, pluginConfig, DEFAULT_URL_TO_CLASSLOADER);
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginConfig, BiConsumer<ClassLoader, URL> addURLToClassLoaderConsumer) {
        this.pluginDir = pluginDir;
        this.pluginConfig = pluginConfig;
        this.addURLToClassLoaderConsumer = addURLToClassLoaderConsumer;
        log.info("Load {} Plugin from {}", (Object)this.getPluginBaseClass().getSimpleName(), (Object)pluginDir);
    }

    protected static Config loadConnectorPluginConfig() {
        return ConfigFactory.parseFile(Common.connectorDir().resolve(PLUGIN_MAPPING_FILE).toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
    }

    @Override
    public List<URL> getPluginJarPaths(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::getPluginJarPath).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    @Override
    public List<T> getAllPlugins(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::createPluginInstance).distinct().collect(Collectors.toList());
    }

    public static Map<PluginIdentifier, String> getAllSupportedPlugins(PluginType pluginType) {
        Config config = AbstractPluginDiscovery.loadConnectorPluginConfig();
        HashMap<PluginIdentifier, String> pluginIdentifiers = new HashMap<PluginIdentifier, String>();
        if (config.isEmpty() || !config.hasPath("seatunnel")) {
            return pluginIdentifiers;
        }
        Config engineConfig = config.getConfig("seatunnel");
        if (engineConfig.hasPath(pluginType.getType())) {
            engineConfig.getConfig(pluginType.getType()).entrySet().forEach(entry -> pluginIdentifiers.put(PluginIdentifier.of("seatunnel", pluginType.getType(), (String)entry.getKey()), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        return pluginIdentifiers;
    }

    public Path getPluginDir() {
        return this.pluginDir;
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier) {
        return this.createPluginInstance(pluginIdentifier, Collections.EMPTY_LIST);
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier, Collection<URL> pluginJars) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        T pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
        if (pluginInstance != null) {
            log.info("Load plugin: {} from classpath", (Object)pluginIdentifier);
            return pluginInstance;
        }
        Optional<URL> pluginJarPath = this.getPluginJarPath(pluginIdentifier);
        if (pluginJarPath.isPresent()) {
            try {
                this.addURLToClassLoaderConsumer.accept(classLoader, pluginJarPath.get());
                for (URL jar : pluginJars) {
                    this.addURLToClassLoaderConsumer.accept(classLoader, jar);
                }
            }
            catch (Exception e) {
                log.warn("can't load jar use current thread classloader, use URLClassLoader instead now. message: " + e.getMessage());
                URL[] urls = new URL[pluginJars.size() + 1];
                int i = 0;
                for (URL pluginJar : pluginJars) {
                    urls[i++] = pluginJar;
                }
                urls[i] = pluginJarPath.get();
                classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            }
            if ((pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader)) != null) {
                log.info("Load plugin: {} from path: {} use classloader: {}", pluginIdentifier, pluginJarPath.get(), classLoader.getClass().getName());
                return pluginInstance;
            }
        }
        throw new RuntimeException("Plugin " + pluginIdentifier + " not found.");
    }

    public Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> getAllPlugin() throws IOException {
        List<Factory> factories;
        if (this.pluginDir.toFile().exists()) {
            log.info("load plugin from plugin dir: {}", (Object)this.pluginDir);
            List<URL> files = FileUtils.searchJarFiles(this.pluginDir);
            factories = FactoryUtil.discoverFactories(new URLClassLoader(files.toArray(new URL[0])));
        } else {
            log.warn("plugin dir: {} not exists, load plugin from classpath", (Object)this.pluginDir);
            factories = FactoryUtil.discoverFactories(Thread.currentThread().getContextClassLoader());
        }
        HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> plugins = new HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>>();
        factories.forEach(plugin -> {
            if (TableSourceFactory.class.isAssignableFrom(plugin.getClass())) {
                TableSourceFactory tableSourceFactory = (TableSourceFactory)plugin;
                plugins.computeIfAbsent(PluginType.SOURCE, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get((Object)PluginType.SOURCE)).put(PluginIdentifier.of("seatunnel", PluginType.SOURCE.getType(), plugin.factoryIdentifier()), FactoryUtil.sourceFullOptionRule(tableSourceFactory));
                return;
            }
            if (TableSinkFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.SINK, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get((Object)PluginType.SINK)).put(PluginIdentifier.of("seatunnel", PluginType.SINK.getType(), plugin.factoryIdentifier()), FactoryUtil.sinkFullOptionRule((TableSinkFactory)plugin));
                return;
            }
            if (TableTransformFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.TRANSFORM, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get((Object)PluginType.TRANSFORM)).put(PluginIdentifier.of("seatunnel", PluginType.TRANSFORM.getType(), plugin.factoryIdentifier()), plugin.optionRule());
                return;
            }
        });
        return plugins;
    }

    private T loadPluginInstance(PluginIdentifier pluginIdentifier, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(this.getPluginBaseClass(), classLoader);
        for (T t : serviceLoader) {
            if (t instanceof PluginIdentifierInterface) {
                PluginIdentifierInterface pluginIdentifierInstance = (PluginIdentifierInterface)t;
                if (!StringUtils.equalsIgnoreCase(pluginIdentifierInstance.getPluginName(), pluginIdentifier.getPluginName())) continue;
                return (T)pluginIdentifierInstance;
            }
            throw new UnsupportedOperationException("Plugin instance: " + t + " is not supported.");
        }
        return null;
    }

    protected Optional<URL> getPluginJarPath(PluginIdentifier pluginIdentifier) {
        return this.pluginJarPath.computeIfAbsent(pluginIdentifier, this::findPluginJarPath);
    }

    protected abstract Class<T> getPluginBaseClass();

    private Optional<URL> findPluginJarPath(PluginIdentifier pluginIdentifier) {
        if (this.pluginConfig.isEmpty()) {
            return Optional.empty();
        }
        String engineType = pluginIdentifier.getEngineType().toLowerCase();
        String pluginType = pluginIdentifier.getPluginType().toLowerCase();
        String pluginName = pluginIdentifier.getPluginName().toLowerCase();
        if (!this.pluginConfig.hasPath(engineType)) {
            return Optional.empty();
        }
        Config engineConfig = this.pluginConfig.getConfig(engineType);
        if (!engineConfig.hasPath(pluginType)) {
            return Optional.empty();
        }
        Config typeConfig = engineConfig.getConfig(pluginType);
        Optional<Map.Entry> optional = typeConfig.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), pluginName)).findFirst();
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        final String pluginJarPrefix = ((ConfigValue)optional.get().getValue()).unwrapped().toString();
        Object[] targetPluginFiles = this.pluginDir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && StringUtils.startsWithIgnoreCase(pathname.getName(), pluginJarPrefix);
            }
        });
        if (ArrayUtils.isEmpty(targetPluginFiles)) {
            return Optional.empty();
        }
        try {
            URL pluginJarPath = ((File)targetPluginFiles[0]).toURI().toURL();
            log.info("Discovery plugin jar: {} at: {}", (Object)pluginIdentifier.getPluginName(), (Object)pluginJarPath);
            return Optional.of(pluginJarPath);
        }
        catch (MalformedURLException e) {
            log.warn("Cannot get plugin URL: " + targetPluginFiles[0], e);
            return Optional.empty();
        }
    }
}

