/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager;

import com.hazelcast.spi.impl.NodeEngine;
import org.apache.seatunnel.engine.common.runtime.DeployType;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.StandaloneResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.UnsupportedDeployTypeException;
import org.apache.seatunnel.engine.server.resourcemanager.thirdparty.kubernetes.KubernetesResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.thirdparty.yarn.YarnResourceManager;

public class ResourceManagerFactory {
    private final NodeEngine nodeEngine;

    public ResourceManagerFactory(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public ResourceManager getResourceManager(DeployType type) {
        if (DeployType.STANDALONE.equals((Object)type)) {
            return new StandaloneResourceManager(this.nodeEngine);
        }
        if (DeployType.KUBERNETES.equals((Object)type)) {
            return new KubernetesResourceManager(this.nodeEngine);
        }
        if (DeployType.YARN.equals((Object)type)) {
            return new YarnResourceManager(this.nodeEngine);
        }
        throw new UnsupportedDeployTypeException(type);
    }

    public ResourceManager getResourceManager() {
        return this.getResourceManager(DeployType.STANDALONE);
    }
}

