/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class DelegatingCompletableFuture<V>
extends InternalCompletableFuture<V> {
    protected static final Object VOID = new Object(){

        public String toString() {
            return "void";
        }
    };
    private static final AtomicReferenceFieldUpdater<DelegatingCompletableFuture, Object> DESERIALIZED_VALUE = AtomicReferenceFieldUpdater.newUpdater(DelegatingCompletableFuture.class, Object.class, "deserializedValue");
    protected final CompletableFuture future;
    protected final InternalSerializationService serializationService;
    protected final Object result;
    protected volatile Object deserializedValue = VOID;

    public DelegatingCompletableFuture(@Nonnull SerializationService serializationService, @Nonnull CompletableFuture future) {
        this(serializationService, future, null);
    }

    public DelegatingCompletableFuture(@Nonnull SerializationService serializationService, @Nonnull CompletableFuture future, V result2) {
        this(serializationService, future, result2, true);
    }

    protected DelegatingCompletableFuture(@Nonnull SerializationService serializationService, @Nonnull CompletableFuture future, V result2, boolean listenFutureCompletion) {
        this.future = future;
        this.serializationService = (InternalSerializationService)serializationService;
        this.result = result2;
        if (listenFutureCompletion) {
            this.future.whenComplete((T v, U t) -> this.completeSuper(v, (Throwable)t));
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.resolve(this.future.get());
        }
        catch (HazelcastSerializationException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.resolve(this.future.get(timeout, unit));
        }
        catch (HazelcastSerializationException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V getNow(V valueIfAbsent) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        V value = this.future.getNow(valueIfAbsent);
        try {
            return (V)(value instanceof Data ? this.serializationService.toObject(value) : value);
        }
        catch (HazelcastSerializationException e) {
            throw new CompletionException(e);
        }
    }

    @Override
    public V join() {
        try {
            return this.resolve(this.future.join());
        }
        catch (HazelcastSerializationException e) {
            throw new CompletionException(e);
        }
    }

    @Override
    public V joinInternal() {
        if (this.future instanceof InternalCompletableFuture) {
            return this.resolve(((InternalCompletableFuture)this.future).joinInternal());
        }
        try {
            return this.resolve(this.future.join());
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            throw ExceptionUtil.sneakyThrow(AbstractInvocationFuture.wrapOrPeel(cause));
        }
    }

    public Future getDelegate() {
        return this.future;
    }

    protected V resolve(Object object) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        if (object instanceof Data) {
            Data data = (Data)object;
            object = this.serializationService.toObject(data);
            this.serializationService.disposeData(data);
            object = this.cacheDeserializedValue(object);
        }
        return (V)object;
    }

    protected Object cacheDeserializedValue(Object object) {
        do {
            Object current;
            if ((current = this.deserializedValue) == VOID) continue;
            object = current;
            break;
        } while (!DESERIALIZED_VALUE.compareAndSet(this, VOID, object));
        return object;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean complete(V value) {
        boolean triggered = this.future.complete(value);
        if (triggered) {
            super.complete(value);
        }
        return triggered;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean triggered = this.future.completeExceptionally(ex);
        if (triggered) {
            super.completeExceptionally(ex);
        }
        return triggered;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.future.thenApply(new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(new DeserializingFunction<V, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super V> action) {
        return this.future.thenAccept(new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.future.thenAcceptAsync(new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return this.future.thenAcceptAsync(new DeserializingConsumer<V>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.future.thenRun(new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(new DeserializingRunnable(this.serializationService, action), executor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombine((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBoth((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action), executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEither(other, new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEitherAsync(other, new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return this.future.applyToEitherAsync(other, new DeserializingFunction<V, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEither(other, new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEitherAsync(other, new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return this.future.acceptEitherAsync(other, new DeserializingConsumer<V>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, (Runnable)new DeserializingRunnable(this.serializationService, action), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenCompose(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenComplete(new WhenCompleteBiConsumer<V, Throwable>(this.serializationService, action)));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenCompleteAsync(new WhenCompleteBiConsumer<V, Throwable>(this.serializationService, action)));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenCompleteAsync(new WhenCompleteBiConsumer<V, Throwable>(this.serializationService, action), executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handle(new HandleBiFunction<V, Throwable, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(new HandleBiFunction<V, Throwable, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(new HandleBiFunction<V, Throwable, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<V> exceptionally(Function<Throwable, ? extends V> fn) {
        return this.future.handle((BiFunction)new ExceptionallyBiFunction(this.serializationService, fn));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        if (super.isDone()) {
            return super.isCompletedExceptionally();
        }
        if (this.future.isDone()) {
            try {
                this.resolve(this.future.join());
                return false;
            }
            catch (Throwable t) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void obtrudeValue(V value) {
        this.future.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.future.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.future.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.future.toString();
    }

    public V getDeserializedValue() {
        return (V)this.deserializedValue;
    }

    protected void completeSuper(Object value, Throwable t) {
        if (t != null) {
            super.completeExceptionally(t);
        } else {
            try {
                V resolved = this.resolve(value);
                super.complete(resolved);
            }
            catch (HazelcastSerializationException e) {
                super.completeExceptionally(e);
            }
        }
    }

    static class ExceptionallyBiFunction<T, U extends Throwable, R>
    implements BiFunction<T, U, R> {
        private final SerializationService serializationService;
        private final Function<U, R> delegate;

        ExceptionallyBiFunction(SerializationService serializationService, Function<U, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(T t, U u) {
            if (u != null) {
                return this.delegate.apply(u);
            }
            try {
                Object deserialized = this.serializationService.toObject(t);
                return (R)deserialized;
            }
            catch (HazelcastSerializationException exc) {
                u = exc;
                return this.delegate.apply(u);
            }
        }
    }

    static class WhenCompleteBiConsumer<E, T extends Throwable>
    implements BiConsumer<E, T> {
        private final SerializationService serializationService;
        private final BiConsumer<E, T> delegate;

        WhenCompleteBiConsumer(SerializationService serializationService, BiConsumer<E, T> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void accept(E v, T t) {
            Object deserialized = null;
            try {
                deserialized = this.serializationService.toObject(v);
            }
            catch (HazelcastSerializationException exc) {
                t = exc;
            }
            this.delegate.accept(deserialized, t);
        }
    }

    static class DeserializingBiConsumer<T, U>
    implements BiConsumer<T, U> {
        private final SerializationService serializationService;
        private final BiConsumer<T, U> delegate;

        DeserializingBiConsumer(SerializationService serializationService, BiConsumer<T, U> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void accept(T t, U u) {
            Object v1 = this.serializationService.toObject(t);
            Object v2 = this.serializationService.toObject(u);
            this.delegate.accept(v1, v2);
        }
    }

    static class HandleBiFunction<T, U extends Throwable, R>
    implements BiFunction<T, U, R> {
        private final SerializationService serializationService;
        private final BiFunction<T, U, R> delegate;

        HandleBiFunction(SerializationService serializationService, BiFunction<T, U, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(T t, U u) {
            Object deserialized = null;
            try {
                deserialized = this.serializationService.toObject(t);
            }
            catch (HazelcastSerializationException exc) {
                u = exc;
            }
            return this.delegate.apply(deserialized, u);
        }
    }

    static class DeserializingBiFunction<T, U, R>
    implements BiFunction<T, U, R> {
        private final SerializationService serializationService;
        private final BiFunction<T, U, R> delegate;

        DeserializingBiFunction(SerializationService serializationService, BiFunction<T, U, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(T t, U u) {
            Object v1 = this.serializationService.toObject(t);
            Object v2 = this.serializationService.toObject(u);
            return this.delegate.apply(v1, v2);
        }
    }

    static class DeserializingConsumer<E>
    implements Consumer<E> {
        private final SerializationService serializationService;
        private final Consumer<E> delegate;

        DeserializingConsumer(SerializationService serializationService, Consumer<E> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void accept(E e) {
            this.delegate.accept(this.serializationService.toObject(e));
        }
    }

    class DeserializingRunnable
    implements Runnable {
        private final SerializationService serializationService;
        private final Runnable delegate;

        DeserializingRunnable(SerializationService serializationService, Runnable delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.serializationService.toObject(DelegatingCompletableFuture.this.future.join());
            this.delegate.run();
        }
    }

    static class DeserializingFunction<E, R>
    implements Function<E, R> {
        private final SerializationService serializationService;
        private final Function<E, R> delegate;

        DeserializingFunction(SerializationService serializationService, Function<E, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(E e) {
            return this.delegate.apply(this.serializationService.toObject(e));
        }
    }
}

