/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.TopologicalSorter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.FlatMapTransform;
import com.hazelcast.jet.impl.pipeline.transform.MapTransform;
import com.hazelcast.jet.impl.pipeline.transform.SinkTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.TimestampTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Planner {
    private static final ILogger LOGGER = Logger.getLogger(Planner.class);
    private static final int MAXIMUM_WATERMARK_GAP = 1000;
    public final DAG dag = new DAG();
    public final Map<Transform, PlannerVertex> xform2vertex = new HashMap<Transform, PlannerVertex>();
    private final PipelineImpl pipeline;

    Planner(PipelineImpl pipeline) {
        this.pipeline = pipeline;
    }

    public boolean isPreserveOrder() {
        return this.pipeline.isPreserveOrder();
    }

    DAG createDag(PipelineImpl.Context context) {
        this.pipeline.makeNamesUnique();
        Map<Transform, List<Transform>> adjacencyMap = this.pipeline.adjacencyMap();
        Planner.validateNoLeakage(adjacencyMap);
        TopologicalSorter.checkTopologicalSort(adjacencyMap.entrySet());
        long frameSizeGcd = Util.gcd(adjacencyMap.keySet().stream().map(Transform::preferredWatermarkStride).filter(frameSize -> frameSize > 0L).mapToLong(i -> i).toArray());
        if (frameSizeGcd == 0L) {
            frameSizeGcd = 1000L;
        }
        if (frameSizeGcd > 1000L) {
            frameSizeGcd = Util.gcd(frameSizeGcd, 1000L);
        }
        LoggingUtil.logFine(LOGGER, "Watermarks in the pipeline will be throttled to %d", frameSizeGcd);
        for (Transform transform2 : adjacencyMap.keySet()) {
            AbstractTransform t;
            if (transform2 instanceof StreamSourceTransform) {
                t = (StreamSourceTransform)transform2;
                EventTimePolicy eventTimePolicy = ((StreamSourceTransform)t).getEventTimePolicy();
                if (eventTimePolicy == null) continue;
                ((StreamSourceTransform)t).setEventTimePolicy(Planner.withFrameSize(eventTimePolicy, frameSizeGcd));
                continue;
            }
            if (!(transform2 instanceof TimestampTransform)) continue;
            t = (TimestampTransform)transform2;
            ((TimestampTransform)t).setEventTimePolicy(Planner.withFrameSize(((TimestampTransform)t).getEventTimePolicy(), frameSizeGcd));
        }
        HashMap<Transform, ArrayList<Transform>> originalParents = new HashMap<Transform, ArrayList<Transform>>();
        ArrayList<Transform> transforms = new ArrayList<Transform>(adjacencyMap.keySet());
        for (int i2 = 0; i2 < transforms.size(); ++i2) {
            Transform transform2 = (Transform)transforms.get(i2);
            List<Transform> chain2 = Planner.findFusableChain(transform2, adjacencyMap);
            if (chain2 == null) continue;
            transforms.removeAll(chain2.subList(1, chain2.size()));
            Transform fused = Planner.fuseFlatMapTransforms(chain2);
            transforms.set(i2, fused);
            Transform lastInChain = chain2.get(chain2.size() - 1);
            for (Transform downstream : adjacencyMap.get(lastInChain)) {
                originalParents.put(downstream, new ArrayList<Transform>(downstream.upstream()));
                downstream.upstream().replaceAll(p -> p == lastInChain ? fused : p);
            }
        }
        for (Transform transform3 : transforms) {
            transform3.addToDag(this, context);
        }
        for (Map.Entry entry : originalParents.entrySet()) {
            List<Transform> upstream = ((Transform)entry.getKey()).upstream();
            for (int i3 = 0; i3 < upstream.size(); ++i3) {
                ((Transform)entry.getKey()).upstream().set(i3, (Transform)((List)entry.getValue()).get(i3));
            }
        }
        return this.dag;
    }

    private static List<Transform> findFusableChain(@Nonnull Transform transform2, @Nonnull Map<Transform, List<Transform>> adjacencyMap) {
        ArrayList<Transform> chain2 = new ArrayList<Transform>();
        while (transform2 instanceof MapTransform || transform2 instanceof FlatMapTransform) {
            Transform nextTransform;
            chain2.add(transform2);
            List<Transform> downstream = adjacencyMap.get(transform2);
            if (downstream.size() != 1 || (nextTransform = downstream.get(0)).localParallelism() != transform2.localParallelism() || nextTransform.shouldRebalanceInput(0)) break;
            transform2 = nextTransform;
        }
        return chain2.size() > 1 ? chain2 : null;
    }

    private static Transform fuseFlatMapTransforms(List<Transform> chain2) {
        AbstractTransform fused;
        assert (chain2.size() > 1) : "chain.size()=" + chain2.size();
        assert (chain2.get(0).upstream().size() == 1);
        int lastFlatMap = 0;
        FunctionEx<Object, Traverser> flatMapFn = null;
        for (int i = 0; i < chain2.size(); ++i) {
            if (!(chain2.get(i) instanceof FlatMapTransform)) continue;
            FunctionEx function = ((FlatMapTransform)chain2.get(i)).flatMapFn();
            FunctionEx inputMapFn = Planner.mergeMapFunctions(chain2.subList(lastFlatMap, i));
            flatMapFn = inputMapFn != null ? (flatMapFn == null ? t -> {
                Object mappedValue = inputMapFn.apply(t);
                return mappedValue != null ? (Traverser)function.apply(mappedValue) : Traversers.empty();
            } : flatMapFn.andThen(r -> r.map(inputMapFn).flatMap(function))) : (flatMapFn == null ? function::apply : flatMapFn.andThen(r -> r.flatMap(function)));
            lastFlatMap = i + 1;
        }
        FunctionEx trailingMapFn = Planner.mergeMapFunctions(chain2.subList(lastFlatMap, chain2.size()));
        String name = chain2.stream().map(Transform::name).collect(Collectors.joining(", ", "fused(", ")"));
        if (flatMapFn == null) {
            fused = new MapTransform(name, chain2.get(0).upstream().get(0), trailingMapFn);
        } else {
            if (trailingMapFn != null) {
                flatMapFn = flatMapFn.andThen(t -> t.map(trailingMapFn));
            }
            fused = new FlatMapTransform(name, chain2.get(0).upstream().get(0), flatMapFn);
        }
        fused.setRebalanceInput(0, chain2.get(0).shouldRebalanceInput(0));
        return fused;
    }

    private static FunctionEx mergeMapFunctions(List<Transform> chain2) {
        if (chain2.isEmpty()) {
            return null;
        }
        List<FunctionEx> functions = Util.toList(chain2, t -> ((MapTransform)t).mapFn());
        return t -> {
            Object result2 = t;
            for (int i = 0; i < functions.size() && result2 != null; ++i) {
                result2 = ((FunctionEx)functions.get(i)).apply(result2);
            }
            return result2;
        };
    }

    private static void validateNoLeakage(Map<Transform, List<Transform>> adjacencyMap) {
        List leakages = adjacencyMap.entrySet().stream().filter(e -> !(e.getKey() instanceof SinkTransform)).filter(e -> ((List)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!leakages.isEmpty()) {
            throw new IllegalArgumentException("These transforms have nothing attached to them: " + leakages);
        }
    }

    public PlannerVertex addVertex(Transform transform2, String name, int localParallelism, SupplierEx<Processor> procSupplier) {
        return this.addVertex(transform2, name, localParallelism, ProcessorMetaSupplier.of(procSupplier));
    }

    public PlannerVertex addVertex(Transform transform2, String name, int localParallelism, ProcessorSupplier procSupplier) {
        return this.addVertex(transform2, name, localParallelism, ProcessorMetaSupplier.of(procSupplier));
    }

    public PlannerVertex addVertex(Transform transform2, String name, int localParallelism, ProcessorMetaSupplier metaSupplier) {
        PlannerVertex pv = new PlannerVertex(this.dag.newVertex(name, metaSupplier));
        pv.v.localParallelism(localParallelism);
        this.xform2vertex.put(transform2, pv);
        return pv;
    }

    public void addEdges(Transform transform2, Vertex toVertex, ObjIntConsumer<Edge> configureEdgeFn) {
        int destOrdinal = 0;
        for (Transform fromTransform : transform2.upstream()) {
            PlannerVertex fromPv = this.xform2vertex.get(fromTransform);
            Edge edge = Edge.from(fromPv.v, fromPv.nextAvailableOrdinal()).to(toVertex, destOrdinal);
            this.dag.edge(edge);
            configureEdgeFn.accept(edge, destOrdinal);
            Planner.applyRebalancing(edge, transform2);
            ++destOrdinal;
        }
    }

    public static void applyRebalancing(Edge edge, Transform toTransform) {
        int destOrdinal = edge.getDestOrdinal();
        if (!toTransform.shouldRebalanceInput(destOrdinal)) {
            return;
        }
        edge.distributed();
        FunctionEx<?, ?> keyFn = toTransform.partitionKeyFnForInput(destOrdinal);
        if (keyFn != null) {
            edge.partitioned(keyFn);
        }
        if (edge.getRoutingPolicy() == Edge.RoutingPolicy.ISOLATED) {
            throw new IllegalArgumentException("Using rebalance without a key directly breaks the order. When the \"preserveOrder\" property is active, rebalance without a key is not allowed to use");
        }
    }

    public void addEdges(Transform transform2, Vertex toVertex, Consumer<Edge> configureEdgeFn) {
        this.addEdges(transform2, toVertex, (Edge e, int ord) -> configureEdgeFn.accept((Edge)e));
    }

    public void addEdges(Transform transform2, Vertex toVertex) {
        this.addEdges(transform2, toVertex, (Edge e) -> {});
    }

    @Nonnull
    private static <T> EventTimePolicy<T> withFrameSize(EventTimePolicy<T> original, long watermarkThrottlingFrameSize) {
        return EventTimePolicy.eventTimePolicy(original.timestampFn(), original.wrapFn(), original.newWmPolicyFn(), watermarkThrottlingFrameSize, 0L, original.idleTimeoutMillis());
    }

    public static <E> List<E> tailList(List<E> list) {
        return list.subList(1, list.size());
    }

    public static class PlannerVertex {
        public final Vertex v;
        private int availableOrdinal;

        PlannerVertex(Vertex v) {
            this.v = v;
        }

        public String toString() {
            return this.v.toString();
        }

        public int nextAvailableOrdinal() {
            return this.availableOrdinal++;
        }
    }
}

