/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class JetGetJobIdsMessageTask
extends AbstractMultiTargetMessageTask<JetGetJobIdsCodec.RequestParameters> {
    private transient Address masterAddress;

    JetGetJobIdsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        return () -> new GetJobIdsOperation(((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyName, ((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyJobId);
    }

    @Override
    public Collection<Member> getTargets() {
        this.masterAddress = this.nodeEngine.getClusterService().getMasterAddress();
        if (this.masterAddress == null) {
            throw new IllegalStateException("Master is not known yet");
        }
        if (((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyName != null) {
            MemberImpl masterMember = this.nodeEngine.getClusterService().getMember(this.masterAddress);
            if (masterMember == null) {
                throw new IllegalStateException("Master changed");
            }
            return Collections.singleton(masterMember);
        }
        return this.nodeEngine.getClusterService().getMembers();
    }

    @Override
    protected Object reduce(Map<Member, Object> map2) {
        return map2.entrySet().stream().collect(Collectors.toMap(en -> ((Member)en.getKey()).getUuid(), en -> {
            Object response = en.getValue();
            if (response instanceof MemberLeftException || response instanceof TargetNotMemberException || response instanceof TargetDisconnectedException) {
                return GetJobIdsOperation.GetJobIdsResult.EMPTY;
            }
            if (response instanceof Exception) {
                if (((Member)en.getKey()).getAddress().equals(this.masterAddress)) {
                    throw new RuntimeException((Throwable)response);
                }
                return GetJobIdsOperation.GetJobIdsResult.EMPTY;
            }
            return response;
        }));
    }

    @Override
    protected JetGetJobIdsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return JetGetJobIdsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return JetGetJobIdsCodec.encodeResponse(this.serializationService.toData(response));
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getJobIds";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new JobPermission(new String[]{"read"});
    }
}

