/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.util.BiTuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class ListCNFixedSizeCodec {
    private static final byte TYPE_NULL_ONLY = 1;
    private static final byte TYPE_NOT_NULL_ONLY = 2;
    private static final byte TYPE_MIXED = 3;
    private static final int ITEMS_PER_BITMASK = 8;
    private static final int HEADER_SIZE = 5;

    private ListCNFixedSizeCodec() {
    }

    public static <T> void encode(ClientMessage clientMessage, Iterable<T> items, int itemSizeInBytes, EncodeFunction<T> encodeFunction) {
        BiTuple<Integer, Integer> itemCounts = ListCNFixedSizeCodec.countItems(items);
        int totalItemCount = (Integer)itemCounts.element1;
        int nonNullItemCount = (Integer)itemCounts.element2;
        int frameSize = ListCNFixedSizeCodec.getFrameSize(nonNullItemCount, totalItemCount, itemSizeInBytes);
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[frameSize]);
        if (nonNullItemCount == 0) {
            ListCNFixedSizeCodec.encodeHeader(frame, (byte)1, totalItemCount);
        } else if (nonNullItemCount == totalItemCount) {
            ListCNFixedSizeCodec.encodeHeader(frame, (byte)2, totalItemCount);
            Iterator<T> iterator2 = items.iterator();
            for (int i = 0; i < totalItemCount; ++i) {
                encodeFunction.encode(frame.content, 5 + i * itemSizeInBytes, iterator2.next());
            }
        } else {
            ListCNFixedSizeCodec.encodeHeader(frame, (byte)3, totalItemCount);
            int bitmaskPosition = 5;
            int nextItemPosition = bitmaskPosition + 1;
            int bitmask = 0;
            int trackedItems = 0;
            for (T item : items) {
                if (item != null) {
                    bitmask |= 1 << trackedItems;
                    encodeFunction.encode(frame.content, nextItemPosition, item);
                    nextItemPosition += itemSizeInBytes;
                }
                if (++trackedItems != 8) continue;
                FixedSizeTypesCodec.encodeByte(frame.content, bitmaskPosition, (byte)bitmask);
                bitmaskPosition = nextItemPosition;
                nextItemPosition = bitmaskPosition + 1;
                bitmask = 0;
                trackedItems = 0;
            }
            if (trackedItems != 0) {
                FixedSizeTypesCodec.encodeByte(frame.content, bitmaskPosition, (byte)bitmask);
            }
        }
        clientMessage.add(frame);
    }

    private static void encodeHeader(ClientMessage.Frame frame, byte type, int size2) {
        FixedSizeTypesCodec.encodeByte(frame.content, 0, type);
        FixedSizeTypesCodec.encodeInt(frame.content, 1, size2);
    }

    public static <T> List<T> decode(ClientMessage.Frame frame, int itemSizeInBytes, DecodeFunction<T> decodeFunction) {
        byte type = FixedSizeTypesCodec.decodeByte(frame.content, 0);
        int count2 = FixedSizeTypesCodec.decodeInt(frame.content, 1);
        ArrayList<T> res = new ArrayList<T>(count2);
        switch (type) {
            case 1: {
                for (int i = 0; i < count2; ++i) {
                    res.add(null);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < count2; ++i) {
                    res.add(decodeFunction.decode(frame.content, 5 + i * itemSizeInBytes));
                }
                break;
            }
            default: {
                assert (type == 3);
                int position = 5;
                int readCount = 0;
                while (readCount < count2) {
                    byte bitmask = FixedSizeTypesCodec.decodeByte(frame.content, position++);
                    for (int i = 0; i < 8 && readCount < count2; ++readCount, ++i) {
                        int mask = 1 << i;
                        if ((bitmask & mask) == mask) {
                            res.add(decodeFunction.decode(frame.content, position));
                            position += itemSizeInBytes;
                            continue;
                        }
                        res.add(null);
                    }
                }
                assert (readCount == res.size());
                break;
            }
        }
        return res;
    }

    private static <T> BiTuple<Integer, Integer> countItems(Iterable<T> items) {
        int total = 0;
        int nonNull = 0;
        for (T item : items) {
            ++total;
            if (item == null) continue;
            ++nonNull;
        }
        return BiTuple.of(total, nonNull);
    }

    private static int getFrameSize(int nonNullItemCount, int totalItemCount, int itemSizeInBytes) {
        int payload;
        if (nonNullItemCount == 0) {
            payload = 0;
        } else if (nonNullItemCount == totalItemCount) {
            payload = totalItemCount * itemSizeInBytes;
        } else {
            int nonNullItemCumulativeSize = nonNullItemCount * itemSizeInBytes;
            int bitmaskCumulativeSize = totalItemCount / 8 + (totalItemCount % 8 > 0 ? 1 : 0);
            payload = nonNullItemCumulativeSize + bitmaskCumulativeSize;
        }
        return 5 + payload;
    }

    @FunctionalInterface
    public static interface DecodeFunction<T> {
        public T decode(byte[] var1, int var2);
    }

    @FunctionalInterface
    public static interface EncodeFunction<T> {
        public void encode(byte[] var1, int var2, T var3);
    }
}

