/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.filterrowkind;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.FilterRowTransform;
import org.apache.seatunnel.transform.filterrowkind.FilterRowKindTransformFactory;
import org.apache.seatunnel.transform.filterrowkind.FilterRowKinkTransformConfig;

@AutoService(value={SeaTunnelTransform.class})
public class FilterRowKindTransform
extends FilterRowTransform {
    public static String PLUGIN_NAME = "FilterRowKind";
    private Set<RowKind> includeKinds = Collections.emptySet();
    private Set<RowKind> excludeKinds = Collections.emptySet();

    public FilterRowKindTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.initConfig(config);
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    private void initConfig(ReadonlyConfig config) {
        if (config.get(FilterRowKinkTransformConfig.INCLUDE_KINDS) == null) {
            this.excludeKinds = new HashSet<RowKind>((Collection)config.get(FilterRowKinkTransformConfig.EXCLUDE_KINDS));
        } else {
            this.includeKinds = new HashSet<RowKind>((Collection)config.get(FilterRowKinkTransformConfig.INCLUDE_KINDS));
        }
        if (this.includeKinds.isEmpty() && this.excludeKinds.isEmpty() || !this.includeKinds.isEmpty() && !this.excludeKinds.isEmpty()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("These options(%s,%s) are mutually exclusive, allowing only one set of options to be configured.", FilterRowKinkTransformConfig.INCLUDE_KINDS.key(), FilterRowKinkTransformConfig.EXCLUDE_KINDS.key()));
        }
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new FilterRowKindTransformFactory().optionRule());
        this.initConfig(ReadonlyConfig.fromConfig((Config)pluginConfig));
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        if (!this.excludeKinds.isEmpty()) {
            return this.excludeKinds.contains(inputRow.getRowKind()) ? null : inputRow;
        }
        if (!this.includeKinds.isEmpty()) {
            Set<RowKind> includeKinds = this.includeKinds;
            return includeKinds.contains(inputRow.getRowKind()) ? inputRow : null;
        }
        throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "Transform config error! Either excludeKinds or includeKinds must be configured");
    }

    public String toString() {
        return "FilterRowKindTransform(includeKinds=" + this.includeKinds + ", excludeKinds=" + this.excludeKinds + ")";
    }

    public FilterRowKindTransform() {
    }
}

