/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.google.common.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.shade.com.google.common.annotations.GwtCompatible;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableMultiset;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableSet;
import org.apache.seatunnel.shade.com.google.common.collect.Maps;
import org.apache.seatunnel.shade.com.google.common.collect.Multiset;
import org.apache.seatunnel.shade.com.google.common.collect.Multisets;
import org.apache.seatunnel.shade.com.google.common.primitives.Ints;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        Object[] entriesArray = entries.toArray(new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size2 = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count2 = entry.getCount();
            size2 += (long)count2;
            Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, count2);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count2);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size2);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size2) {
        this.delegateMap = delegateMap;
        this.entries = entries;
        this.size = size2;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.delegateMap.getOrDefault(element, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

