/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.TextCommandServiceImpl;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.NodeExtensionCommon;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.log.Log4j2HttpGetCommandProcessor;
import org.apache.seatunnel.engine.server.log.Log4j2HttpPostCommandProcessor;
import org.apache.seatunnel.engine.server.rest.RestHttpGetCommandProcessor;

public class NodeExtension
extends DefaultNodeExtension {
    private final NodeExtensionCommon extCommon;

    public NodeExtension(@NonNull Node node, @NonNull SeaTunnelConfig seaTunnelConfig) {
        super(node);
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.extCommon = new NodeExtensionCommon(node, new SeaTunnelServer(seaTunnelConfig));
    }

    @Override
    public void beforeStart() {
        super.beforeStart();
    }

    @Override
    public void afterStart() {
        super.afterStart();
        this.extCommon.afterStart();
    }

    @Override
    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
        super.beforeClusterStateChange(currState, requestedState, isTransient);
        this.extCommon.beforeClusterStateChange(requestedState);
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        super.onClusterStateChange(newState, isTransient);
        this.extCommon.onClusterStateChange(newState);
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        return this.extCommon.createExtensionServices();
    }

    @Override
    public TextCommandService createTextCommandService() {
        return new TextCommandServiceImpl(this.node){
            {
                this.register(TextCommandConstants.TextCommandType.HTTP_GET, new Log4j2HttpGetCommandProcessor(this));
                this.register(TextCommandConstants.TextCommandType.HTTP_POST, new Log4j2HttpPostCommandProcessor(this));
                this.register(TextCommandConstants.TextCommandType.HTTP_GET, new RestHttpGetCommandProcessor(this));
            }
        };
    }

    @Override
    public void printNodeInfo() {
        this.extCommon.printNodeInfo(this.systemLogger);
    }
}

