/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.command.UsageFormatter;

public class CommandLineUtils {
    private CommandLineUtils() {
        throw new UnsupportedOperationException("CommandLineUtils is a utility class and cannot be instantiated");
    }

    public static <T extends CommandArgs> T parse(String[] args, T obj) {
        return CommandLineUtils.parse(args, obj, null, false);
    }

    public static <T extends CommandArgs> T parse(String[] args, T obj, String programName, boolean acceptUnknownOptions) {
        JCommander jCommander = JCommander.newBuilder().programName(programName).addObject(obj).acceptUnknownOptions(acceptUnknownOptions).build();
        try {
            jCommander.parse(args);
            obj.setOriginalParameters(jCommander.getUnknownOptions());
        }
        catch (ParameterException e) {
            System.err.println(e.getLocalizedMessage());
            CommandLineUtils.exit(jCommander);
        }
        if (obj.isHelp()) {
            CommandLineUtils.exit(jCommander);
        }
        return obj;
    }

    private static void exit(JCommander jCommander) {
        jCommander.setUsageFormatter(new UsageFormatter(jCommander));
        jCommander.usage();
        System.exit(234);
    }
}

