/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.predicate;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.BiExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;

public final class ComparisonPredicate
extends BiExpression<Boolean>
implements IdentifiedDataSerializable {
    private ComparisonMode mode;

    public ComparisonPredicate() {
    }

    private ComparisonPredicate(Expression<?> left, Expression<?> right, ComparisonMode mode) {
        super(left, right);
        this.mode = mode;
    }

    public static ComparisonPredicate create(Expression<?> left, Expression<?> right, ComparisonMode comparisonMode) {
        assert (left.getType().equals(right.getType()));
        return new ComparisonPredicate(left, right, comparisonMode);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Any SQL expression may return null")
    public Boolean eval(Row row, ExpressionEvalContext context) {
        Object left = this.operand1.eval(row, context);
        if (left == null) {
            return null;
        }
        Object right = this.operand2.eval(row, context);
        if (right == null) {
            return null;
        }
        if (this.operand1.getType().getTypeFamily() == QueryDataTypeFamily.OBJECT) {
            Class<?> rightClass;
            Class<?> leftClass = left.getClass();
            if (!leftClass.equals(rightClass = right.getClass())) {
                throw QueryException.error("Cannot compare two OBJECT values, because left operand has " + leftClass + " type and right operand has " + rightClass + " type");
            }
            if (!(left instanceof Comparable)) {
                throw QueryException.error("Cannot compare OBJECT value because " + leftClass + " doesn't implement Comparable interface");
            }
        }
        Comparable leftComparable = (Comparable)left;
        Comparable rightComparable = (Comparable)right;
        int order = leftComparable.compareTo(rightComparable);
        switch (this.mode) {
            case EQUALS: {
                return order == 0;
            }
            case NOT_EQUALS: {
                return order != 0;
            }
            case GREATER_THAN: {
                return order > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return order >= 0;
            }
            case LESS_THAN: {
                return order < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return order <= 0;
            }
        }
        throw new IllegalStateException("unexpected comparison mode: " + (Object)((Object)this.mode));
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.BOOLEAN;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.mode.getId());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.mode = ComparisonMode.getById(in.readInt());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operand1, this.operand2, this.mode});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonPredicate that = (ComparisonPredicate)o;
        return Objects.equals(this.operand1, that.operand1) && Objects.equals(this.operand2, that.operand2) && this.mode == that.mode;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{mode=" + (Object)((Object)this.mode) + ", operand1=" + this.operand1 + ", operand2=" + this.operand2 + '}';
    }
}

