/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import java.io.IOException;

public class ReadOneOperation
extends AbstractRingBufferOperation
implements BlockingOperation,
ReadonlyOperation {
    private long sequence;
    private Data result;

    public ReadOneOperation() {
    }

    public ReadOneOperation(String name, long sequence2) {
        super(name);
        this.sequence = sequence2;
    }

    @Override
    public void beforeRun() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainerOrNull();
        if (ringbuffer != null) {
            ringbuffer.checkBlockableReadSequence(this.sequence);
        }
    }

    @Override
    public boolean shouldWait() {
        RingbufferContainer ringbuffer = this.getRingBufferContainerOrNull();
        if (ringbuffer == null) {
            return true;
        }
        if (ringbuffer.isTooLargeSequence(this.sequence) || ringbuffer.isStaleSequence(this.sequence)) {
            return false;
        }
        return this.sequence == ringbuffer.tailSequence() + 1L;
    }

    @Override
    public void run() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        this.result = ringbuffer.readAsData(this.sequence);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getRingbufferWaitNotifyKey();
    }

    @Override
    public void afterRun() throws Exception {
        this.reportReliableTopicReceived(1);
    }

    @Override
    public void onWaitExpire() {
    }

    @Override
    public Data getResponse() {
        return this.result;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.sequence);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.sequence = in.readLong();
    }
}

