/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema;

import com.hazelcast.org.json.JSONObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class StringToValueConverter {
    private static final Set<String> YAML_BOOLEAN_TRUE_LITERALS = new HashSet<String>(Arrays.asList("y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "on", "On", "ON"));
    private static final Set<String> YAML_BOOLEAN_FALSE_LITERALS = new HashSet<String>(Arrays.asList("n", "N", "no", "No", "NO", "false", "False", "FALSE", "off", "Off", "OFF"));

    StringToValueConverter() {
    }

    static Object stringToValue(String string2) {
        if ("".equals(string2)) {
            return string2;
        }
        if (YAML_BOOLEAN_TRUE_LITERALS.contains(string2)) {
            return Boolean.TRUE;
        }
        if (YAML_BOOLEAN_FALSE_LITERALS.contains(string2)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string2)) {
            return JSONObject.NULL;
        }
        char initial = string2.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            try {
                return StringToValueConverter.stringToNumber(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    private static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    private static Number stringToNumber(String val) throws NumberFormatException {
        char initial = val.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            BigInteger bi;
            char at1;
            if (StringToValueConverter.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        Double d = Double.valueOf(val);
                        if (d.isNaN() || d.isInfinite()) {
                            throw new NumberFormatException("val [" + val + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException ignore) {
                        throw new NumberFormatException("val [" + val + "] is not a valid number.");
                    }
                }
            }
            if (initial == '0' && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            } else if (initial == '-' && val.length() > 2) {
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && at2 <= '9') {
                    throw new NumberFormatException("val [" + val + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger(val)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return bi;
        }
        throw new NumberFormatException("val [" + val + "] is not a valid number.");
    }
}

