/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind.entry;

import com.hazelcast.map.impl.mapstore.writebehind.entry.AddedDelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DeletedDelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.entry.NullValueDelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.entry.TxnAddedDelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.entry.TxnDeletedDelayedEntry;
import java.util.UUID;

public final class DelayedEntries {
    private static final DelayedEntry EMPTY_DELAYED_ENTRY = new EmptyDelayedEntry();

    private DelayedEntries() {
    }

    public static <K, V> DelayedEntry<K, V> newAddedDelayedEntry(K key, V value, long expirationTime, long storeTime, int partitionId, UUID txnId) {
        if (txnId != null) {
            return new TxnAddedDelayedEntry<K, V>(key, value, expirationTime, storeTime, partitionId, txnId);
        }
        return new AddedDelayedEntry<K, V>(key, value, expirationTime, storeTime, partitionId);
    }

    public static <K, V> DelayedEntry<K, V> newAddedDelayedEntry(K key) {
        return new AddedDelayedEntry<K, Object>(key, null, Long.MAX_VALUE, -1L, -1);
    }

    public static <K, V> DelayedEntry<K, V> newNullEntry(K key) {
        return new NullValueDelayedEntry(key);
    }

    public static <K, V> DelayedEntry<K, V> newDeletedEntry(K key, long storeTime, int partitionId, UUID txnId) {
        if (txnId != null) {
            return new TxnDeletedDelayedEntry(key, storeTime, partitionId, txnId);
        }
        return new DeletedDelayedEntry(key, storeTime, partitionId);
    }

    public static <K, V> DelayedEntry<K, V> emptyDelayedEntry() {
        return EMPTY_DELAYED_ENTRY;
    }

    private static class EmptyDelayedEntry
    implements DelayedEntry {
        private EmptyDelayedEntry() {
        }

        public Object getKey() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        @Override
        public long getExpirationTime() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getStoreTime() {
            return -1L;
        }

        @Override
        public int getPartitionId() {
            return -1;
        }

        @Override
        public void setStoreTime(long storeTime) {
        }

        @Override
        public void setSequence(long sequence2) {
        }

        @Override
        public long getSequence() {
            return -1L;
        }

        @Override
        public void setTxnId(UUID txnId) {
        }

        @Override
        public UUID getTxnId() {
            return null;
        }
    }
}

