/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import com.hazelcast.spi.impl.DeserializingCompletableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CompletableFutureTask<V>
extends DeserializingCompletableFuture<V>
implements RunnableFuture<V> {
    private static final AtomicReferenceFieldUpdater<CompletableFutureTask, Thread> RUNNER = AtomicReferenceFieldUpdater.newUpdater(CompletableFutureTask.class, Thread.class, "runner");
    private final Callable<V> callable;
    private volatile Thread runner;

    CompletableFutureTask(Callable<V> callable) {
        this.callable = callable;
    }

    CompletableFutureTask(Runnable runnable, V result2) {
        this.callable = Executors.callable(runnable, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDone()) {
            return;
        }
        if (this.runner != null || !RUNNER.compareAndSet(this, null, Thread.currentThread())) {
            return;
        }
        try {
            Callable<V> c = this.callable;
            if (c != null) {
                Object result2 = null;
                try {
                    result2 = c.call();
                    this.complete(result2);
                }
                catch (Throwable ex) {
                    this.completeExceptionally(ex);
                }
            }
        }
        finally {
            this.runner = null;
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Thread executingThread;
        boolean result2 = super.cancel(mayInterruptIfRunning);
        if (result2 && mayInterruptIfRunning && (executingThread = this.runner) != null) {
            executingThread.interrupt();
        }
        return result2;
    }

    @Override
    public String toString() {
        return "CompletableFutureTask{callable=" + this.callable + ", runner=" + this.runner + '}';
    }
}

