/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.concurrent;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public final class ConcurrentItemCounter<T> {
    protected final ConcurrentMap<T, AtomicLong> map = new ConcurrentHashMap<T, AtomicLong>();

    public long total() {
        return this.map.values().parallelStream().collect(Collectors.summingLong(AtomicLong::get));
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public long get(T item) {
        AtomicLong count2 = (AtomicLong)this.map.get(item);
        return count2 == null ? 0L : count2.get();
    }

    public void set(T item, long value) {
        this.getItemCounter(item).set(value);
    }

    public void inc(T item) {
        this.add(item, 1L);
    }

    public void add(T item, long delta) {
        this.getItemCounter(item).addAndGet(delta);
    }

    public void reset() {
        this.clear();
    }

    public void clear() {
        this.map.clear();
    }

    public long getAndSet(T item, long value) {
        return this.getItemCounter(item).getAndSet(value);
    }

    public void remove(T item) {
        this.map.remove(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcurrentItemCounter that = (ConcurrentItemCounter)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private AtomicLong getItemCounter(T item) {
        return this.map.computeIfAbsent(item, k -> new AtomicLong());
    }
}

