/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.tcp.ProtocolException;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.StringUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class SingleProtocolEncoder
extends OutboundHandler<Void, ByteBuffer> {
    private final OutboundHandler[] outboundHandlers;
    private boolean isDecoderVerifiedProtocol;
    private boolean isDecoderReceivedProtocol;
    private boolean clusterProtocolBuffered;
    private String exceptionMessage;

    public SingleProtocolEncoder(OutboundHandler next2) {
        this(new OutboundHandler[]{next2});
    }

    public SingleProtocolEncoder(OutboundHandler[] next2) {
        this.outboundHandlers = next2;
    }

    @Override
    public HandlerStatus onWrite() throws Exception {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            if (!this.isDecoderReceivedProtocol && !this.channel.isClientMode()) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            if (!this.isDecoderVerifiedProtocol && !this.channel.isClientMode()) {
                if (!this.sendProtocol()) {
                    HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                    return handlerStatus;
                }
                throw new ProtocolException(this.exceptionMessage);
            }
            if (this.channel.isClientMode()) {
                this.setupNextEncoder();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            JVMUtil.upcast((Buffer)this.dst).flip();
        }
    }

    private boolean sendProtocol() {
        if (!this.clusterProtocolBuffered) {
            this.clusterProtocolBuffered = true;
            ((ByteBuffer)this.dst).put(StringUtil.stringToBytes("HZX"));
            return false;
        }
        return this.isProtocolBufferDrained();
    }

    protected void setupNextEncoder() {
        this.channel.outboundPipeline().replace(this, this.outboundHandlers);
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer(3);
    }

    private boolean isProtocolBufferDrained() {
        return ((ByteBuffer)this.dst).position() == 0;
    }

    public void signalProtocolVerified() {
        this.isDecoderReceivedProtocol = true;
        this.isDecoderVerifiedProtocol = true;
        this.channel.outboundPipeline().wakeup();
    }

    public void signalWrongProtocol(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
        this.isDecoderReceivedProtocol = true;
        this.isDecoderVerifiedProtocol = false;
        this.channel.outboundPipeline().wakeup();
    }

    public OutboundHandler getFirstOutboundHandler() {
        return this.outboundHandlers[0];
    }
}

