/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.partition.MigrationState;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MigrationStats {
    @Probe(name="lastRepartitionTime", unit=ProbeUnit.MS)
    private final AtomicLong lastRepartitionTime = new AtomicLong();
    @Probe(name="plannedMigrations")
    private volatile int plannedMigrations;
    @Probe(name="completedMigrations")
    private final AtomicInteger completedMigrations = new AtomicInteger();
    @Probe(name="totalCompletedMigrations")
    private final AtomicInteger totalCompletedMigrations = new AtomicInteger();
    @Probe(name="elapsedMigrationOperationTime", unit=ProbeUnit.NS)
    private final AtomicLong elapsedMigrationOperationTime = new AtomicLong();
    @Probe(name="elapsedDestinationCommitTime", unit=ProbeUnit.NS)
    private final AtomicLong elapsedDestinationCommitTime = new AtomicLong();
    @Probe(name="elapsedMigrationTime", unit=ProbeUnit.NS)
    private final AtomicLong elapsedMigrationTime = new AtomicLong();
    @Probe(name="totalElapsedMigrationOperationTime", unit=ProbeUnit.NS)
    private final AtomicLong totalElapsedMigrationOperationTime = new AtomicLong();
    @Probe(name="totalElapsedDestinationCommitTime", unit=ProbeUnit.NS)
    private final AtomicLong totalElapsedDestinationCommitTime = new AtomicLong();
    @Probe(name="totalElapsedMigrationTime", unit=ProbeUnit.NS)
    private final AtomicLong totalElapsedMigrationTime = new AtomicLong();

    void markNewRepartition(int migrations) {
        this.lastRepartitionTime.set(Clock.currentTimeMillis());
        this.plannedMigrations = migrations;
        this.elapsedMigrationOperationTime.set(0L);
        this.elapsedDestinationCommitTime.set(0L);
        this.elapsedMigrationTime.set(0L);
        this.completedMigrations.set(0);
    }

    void incrementCompletedMigrations() {
        this.completedMigrations.incrementAndGet();
        this.totalCompletedMigrations.incrementAndGet();
    }

    void recordMigrationOperationTime(long time) {
        this.elapsedMigrationOperationTime.addAndGet(time);
        this.totalElapsedMigrationOperationTime.addAndGet(time);
    }

    void recordDestinationCommitTime(long time) {
        this.elapsedDestinationCommitTime.addAndGet(time);
        this.totalElapsedDestinationCommitTime.addAndGet(time);
    }

    void recordMigrationTaskTime(long time) {
        this.elapsedMigrationTime.addAndGet(time);
        this.totalElapsedMigrationTime.addAndGet(time);
    }

    public Date getLastRepartitionTime() {
        return new Date(this.lastRepartitionTime.get());
    }

    public int getPlannedMigrations() {
        return this.plannedMigrations;
    }

    public int getCompletedMigrations() {
        return this.completedMigrations.get();
    }

    public int getRemainingMigrations() {
        return this.plannedMigrations - this.completedMigrations.get();
    }

    public int getTotalCompletedMigrations() {
        return this.totalCompletedMigrations.get();
    }

    public long getElapsedMigrationOperationTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.elapsedMigrationOperationTime.get());
    }

    public long getElapsedDestinationCommitTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.elapsedDestinationCommitTime.get());
    }

    public long getElapsedMigrationTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.elapsedMigrationTime.get());
    }

    public long getTotalElapsedMigrationOperationTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalElapsedMigrationOperationTime.get());
    }

    public long getTotalElapsedDestinationCommitTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalElapsedDestinationCommitTime.get());
    }

    public long getTotalElapsedMigrationTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalElapsedMigrationTime.get());
    }

    public MigrationState toMigrationState() {
        return new MigrationStateImpl(this.lastRepartitionTime.get(), this.plannedMigrations, this.completedMigrations.get(), this.getElapsedMigrationTime());
    }

    public String formatToString(boolean detailed) {
        StringBuilder s2 = new StringBuilder();
        s2.append("repartitionTime=").append(this.getLastRepartitionTime()).append(", plannedMigrations=").append(this.plannedMigrations).append(", completedMigrations=").append(this.getCompletedMigrations()).append(", remainingMigrations=").append(this.getRemainingMigrations()).append(", totalCompletedMigrations=").append(this.getTotalCompletedMigrations());
        if (detailed) {
            s2.append(", elapsedMigrationOperationTime=").append(this.getElapsedMigrationOperationTime()).append("ms").append(", totalElapsedMigrationOperationTime=").append(this.getTotalElapsedMigrationOperationTime()).append("ms").append(", elapsedDestinationCommitTime=").append(this.getElapsedDestinationCommitTime()).append("ms").append(", totalElapsedDestinationCommitTime=").append(this.getTotalElapsedDestinationCommitTime()).append("ms").append(", elapsedMigrationTime=").append(this.getElapsedMigrationTime()).append("ms").append(", totalElapsedMigrationTime=").append(this.getTotalElapsedMigrationTime()).append("ms");
        }
        return s2.toString();
    }

    public String toString() {
        return "MigrationStats{" + this.formatToString(true) + "}";
    }
}

