/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore;

import com.hazelcast.cluster.Address;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreEndpoint;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.UUID;

public class AcquireInvocationKey
extends WaitKey
implements IdentifiedDataSerializable {
    private SemaphoreEndpoint endpoint;
    private int permits;

    AcquireInvocationKey() {
    }

    public AcquireInvocationKey(long commitIndex, UUID invocationUid, Address callerAddress, long callId, SemaphoreEndpoint endpoint, int permits) {
        super(commitIndex, invocationUid, callerAddress, callId);
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkTrue(permits > 0, "permits must be positive");
        this.endpoint = endpoint;
        this.permits = permits;
    }

    @Override
    public long sessionId() {
        return this.endpoint.sessionId();
    }

    public SemaphoreEndpoint endpoint() {
        return this.endpoint;
    }

    public int permits() {
        return this.permits;
    }

    boolean isDifferentInvocationOf(SemaphoreEndpoint endpoint, UUID invocationUid) {
        return this.endpoint().equals(endpoint) && !this.invocationUid().equals(invocationUid);
    }

    @Override
    public int getFactoryId() {
        return SemaphoreDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.endpoint);
        out.writeInt(this.permits);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.endpoint = (SemaphoreEndpoint)in.readObject();
        this.permits = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcquireInvocationKey that = (AcquireInvocationKey)o;
        if (this.commitIndex != that.commitIndex) {
            return false;
        }
        if (!this.invocationUid.equals(that.invocationUid)) {
            return false;
        }
        if (!this.callerAddress.equals(that.callerAddress)) {
            return false;
        }
        if (this.callId != that.callId) {
            return false;
        }
        if (!this.endpoint.equals(that.endpoint)) {
            return false;
        }
        return this.permits == that.permits;
    }

    public int hashCode() {
        int result2 = (int)(this.commitIndex ^ this.commitIndex >>> 32);
        result2 = 31 * result2 + this.invocationUid.hashCode();
        result2 = 31 * result2 + this.callerAddress.hashCode();
        result2 = 31 * result2 + (int)(this.callId ^ this.callId >>> 32);
        result2 = 31 * result2 + this.endpoint.hashCode();
        result2 = 31 * result2 + this.permits;
        return result2;
    }

    public String toString() {
        return "AcquireInvocationKey{endpoint=" + this.endpoint + ", permits=" + this.permits + ", commitIndex=" + this.commitIndex + ", invocationUid=" + this.invocationUid + ", callerAddress=" + this.callerAddress + ", callId=" + this.callId + '}';
    }
}

