/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.countdownlatch.proxy;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.countdownlatch.operation.AwaitOp;
import com.hazelcast.cp.internal.datastructures.countdownlatch.operation.CountDownOp;
import com.hazelcast.cp.internal.datastructures.countdownlatch.operation.GetCountOp;
import com.hazelcast.cp.internal.datastructures.countdownlatch.operation.GetRoundOp;
import com.hazelcast.cp.internal.datastructures.countdownlatch.operation.TrySetCountOp;
import com.hazelcast.cp.internal.datastructures.spi.operation.DestroyRaftObjectOp;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.concurrent.TimeUnit;

public class CountDownLatchProxy
implements ICountDownLatch {
    private final RaftInvocationManager invocationManager;
    private final RaftGroupId groupId;
    private final String proxyName;
    private final String objectName;

    public CountDownLatchProxy(NodeEngine nodeEngine, RaftGroupId groupId, String proxyName, String objectName) {
        RaftService service = (RaftService)nodeEngine.getService("hz:core:raft");
        this.invocationManager = service.getInvocationManager();
        this.groupId = groupId;
        this.proxyName = proxyName;
        this.objectName = objectName;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(unit);
        long timeoutMillis = Math.max(0L, unit.toMillis(timeout));
        return (Boolean)this.invocationManager.invoke(this.groupId, new AwaitOp(this.objectName, UuidUtil.newUnsecureUUID(), timeoutMillis)).joinInternal();
    }

    @Override
    public void countDown() {
        int round = (Integer)this.invocationManager.query(this.groupId, new GetRoundOp(this.objectName), QueryPolicy.LINEARIZABLE).joinInternal();
        this.invocationManager.invoke(this.groupId, new CountDownOp(this.objectName, UuidUtil.newUnsecureUUID(), round)).joinInternal();
    }

    @Override
    public int getCount() {
        return (Integer)this.invocationManager.query(this.groupId, new GetCountOp(this.objectName), QueryPolicy.LINEARIZABLE).joinInternal();
    }

    @Override
    public boolean trySetCount(int count2) {
        Preconditions.checkPositive(count2, "Count must be positive!");
        return (Boolean)this.invocationManager.invoke(this.groupId, new TrySetCountOp(this.objectName, count2)).joinInternal();
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.proxyName;
    }

    @Override
    public String getServiceName() {
        return "hz:raft:countDownLatchService";
    }

    @Override
    public void destroy() {
        this.invocationManager.invoke(this.groupId, new DestroyRaftObjectOp(this.getServiceName(), this.objectName)).joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

