/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.SimpleTokenCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Objects;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class TokenIdentityConfig
implements IdentityConfig {
    private final byte[] token;
    private final TokenEncoding encoding;

    private TokenIdentityConfig(TokenIdentityConfig tokenIdentityConfig) {
        this.token = tokenIdentityConfig.token;
        this.encoding = tokenIdentityConfig.encoding;
    }

    public TokenIdentityConfig(TokenEncoding encoding, String encodedToken) {
        this.encoding = Objects.requireNonNull(encoding);
        this.token = encoding.decode(Objects.requireNonNull(encodedToken));
    }

    public TokenIdentityConfig(byte[] token) {
        this.token = Objects.requireNonNull(token);
        this.encoding = TokenEncoding.getEncodingForBytes(token);
    }

    public String getTokenEncoded() {
        return this.encoding.encode(this.token);
    }

    public byte[] getToken() {
        return this.token;
    }

    public TokenEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        return new StaticCredentialsFactory(new SimpleTokenCredentials(this.token));
    }

    @Override
    public IdentityConfig copy() {
        return new TokenIdentityConfig(this);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.encoding == null ? 0 : this.encoding.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.token);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenIdentityConfig other = (TokenIdentityConfig)obj;
        if (this.encoding != other.encoding) {
            return false;
        }
        return Arrays.equals(this.token, other.token);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TokenIdentityConfig [token=***, encoding=").append((Object)this.encoding).append("]");
        return builder.toString();
    }
}

