/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import com.hazelcast.config.security.LdapRoleMappingMode;
import com.hazelcast.config.security.LdapSearchScope;
import com.hazelcast.internal.util.StringUtil;
import java.util.Objects;
import java.util.Properties;

public class LdapAuthenticationConfig
extends AbstractClusterLoginConfig<LdapAuthenticationConfig> {
    private String url;
    private String socketFactoryClassName;
    private String systemUserDn;
    private String systemUserPassword;
    private String systemAuthentication;
    private Boolean parseDn;
    private String roleContext;
    private String roleFilter;
    private String roleMappingAttribute;
    private LdapRoleMappingMode roleMappingMode;
    private String roleNameAttribute;
    private Integer roleRecursionMaxDepth;
    private LdapSearchScope roleSearchScope;
    private String userNameAttribute;
    private String passwordAttribute;
    private String userContext;
    private String userFilter;
    private LdapSearchScope userSearchScope;
    private Boolean skipAuthentication;
    private String securityRealm;

    public String getUrl() {
        return this.url;
    }

    public LdapAuthenticationConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getSocketFactoryClassName() {
        return this.socketFactoryClassName;
    }

    public LdapAuthenticationConfig setSocketFactoryClassName(String socketFactoryClassName) {
        this.socketFactoryClassName = socketFactoryClassName;
        return this;
    }

    public String getSystemUserDn() {
        return this.systemUserDn;
    }

    public LdapAuthenticationConfig setSystemUserDn(String systemUserDn) {
        this.systemUserDn = systemUserDn;
        return this;
    }

    public String getSystemUserPassword() {
        return this.systemUserPassword;
    }

    public LdapAuthenticationConfig setSystemUserPassword(String systemUserPassword) {
        this.systemUserPassword = systemUserPassword;
        return this;
    }

    public Boolean getParseDn() {
        return this.parseDn;
    }

    public boolean isParseDn() {
        return this.parseDn != null && this.parseDn != false;
    }

    public LdapAuthenticationConfig setParseDn(Boolean parseDn) {
        this.parseDn = parseDn;
        return this;
    }

    public String getRoleContext() {
        return this.roleContext;
    }

    public LdapAuthenticationConfig setRoleContext(String roleContext) {
        this.roleContext = roleContext;
        return this;
    }

    public String getRoleFilter() {
        return this.roleFilter;
    }

    public LdapAuthenticationConfig setRoleFilter(String roleFilter) {
        this.roleFilter = roleFilter;
        return this;
    }

    public String getRoleMappingAttribute() {
        return this.roleMappingAttribute;
    }

    public LdapAuthenticationConfig setRoleMappingAttribute(String roleMappingAttribute) {
        this.roleMappingAttribute = roleMappingAttribute;
        return this;
    }

    public LdapRoleMappingMode getRoleMappingMode() {
        return this.roleMappingMode;
    }

    public LdapAuthenticationConfig setRoleMappingMode(LdapRoleMappingMode roleMappingMode) {
        this.roleMappingMode = roleMappingMode;
        return this;
    }

    public String getRoleNameAttribute() {
        return this.roleNameAttribute;
    }

    public LdapAuthenticationConfig setRoleNameAttribute(String roleNameAttribute) {
        this.roleNameAttribute = roleNameAttribute;
        return this;
    }

    public Integer getRoleRecursionMaxDepth() {
        return this.roleRecursionMaxDepth;
    }

    public LdapAuthenticationConfig setRoleRecursionMaxDepth(Integer roleRecursionMaxDepth) {
        this.roleRecursionMaxDepth = roleRecursionMaxDepth;
        return this;
    }

    public LdapSearchScope getRoleSearchScope() {
        return this.roleSearchScope;
    }

    public LdapAuthenticationConfig setRoleSearchScope(LdapSearchScope roleSearchScope) {
        this.roleSearchScope = roleSearchScope;
        return this;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public LdapAuthenticationConfig setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
        return this;
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public LdapAuthenticationConfig setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
        return this;
    }

    public String getUserContext() {
        return this.userContext;
    }

    public LdapAuthenticationConfig setUserContext(String userContext) {
        this.userContext = userContext;
        return this;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public LdapAuthenticationConfig setUserFilter(String userFilter) {
        this.userFilter = userFilter;
        return this;
    }

    public LdapSearchScope getUserSearchScope() {
        return this.userSearchScope;
    }

    public LdapAuthenticationConfig setUserSearchScope(LdapSearchScope userSearchScope) {
        this.userSearchScope = userSearchScope;
        return this;
    }

    public Boolean getSkipAuthentication() {
        return this.skipAuthentication;
    }

    public LdapAuthenticationConfig setSkipAuthentication(Boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
        return this;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public LdapAuthenticationConfig setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
        return this;
    }

    public String getSystemAuthentication() {
        return this.systemAuthentication;
    }

    public LdapAuthenticationConfig setSystemAuthentication(String systemAuthentication) {
        this.systemAuthentication = systemAuthentication;
        return this;
    }

    @Override
    protected Properties initLoginModuleProperties() {
        boolean useSystemAccount;
        Properties props = super.initLoginModuleProperties();
        this.setIfConfigured(props, "java.naming.provider.url", this.url);
        this.setIfConfigured(props, "java.naming.ldap.factory.socket", this.socketFactoryClassName);
        this.setIfConfigured(props, "parseDN", this.parseDn);
        this.setIfConfigured(props, "roleContext", this.roleContext);
        this.setIfConfigured(props, "roleFilter", this.roleFilter);
        this.setIfConfigured(props, "roleMappingAttribute", this.roleMappingAttribute);
        this.setIfConfigured(props, "roleMappingMode", this.roleMappingMode);
        this.setIfConfigured(props, "roleNameAttribute", this.roleNameAttribute);
        this.setIfConfigured(props, "roleRecursionMaxDepth", this.roleRecursionMaxDepth);
        this.setIfConfigured(props, "roleSearchScope", this.roleSearchScope);
        this.setIfConfigured(props, "userNameAttribute", this.userNameAttribute);
        boolean bl = useSystemAccount = !StringUtil.isNullOrEmpty(this.systemUserDn) || !StringUtil.isNullOrEmpty(this.systemAuthentication);
        if (useSystemAccount) {
            this.setIfConfigured(props, "java.naming.security.authentication", this.systemAuthentication);
            this.setIfConfigured(props, "java.naming.security.principal", this.systemUserDn);
            this.setIfConfigured(props, "java.naming.security.credentials", this.systemUserPassword);
            this.setIfConfigured(props, "passwordAttribute", this.passwordAttribute);
            this.setIfConfigured(props, "userContext", this.userContext);
            this.setIfConfigured(props, "userFilter", this.userFilter);
            this.setIfConfigured(props, "userSearchScope", this.userSearchScope);
            this.setIfConfigured(props, "skipAuthentication", this.skipAuthentication);
            this.setIfConfigured(props, "securityRealm", this.securityRealm);
        }
        return props;
    }

    @Override
    public LoginModuleConfig[] asLoginModuleConfigs() {
        boolean useSystemAccount = !StringUtil.isNullOrEmpty(this.systemUserDn) || !StringUtil.isNullOrEmpty(this.systemAuthentication);
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig(useSystemAccount ? "com.hazelcast.security.loginimpl.LdapLoginModule" : "com.hazelcast.security.loginimpl.BasicLdapLoginModule", LoginModuleConfig.LoginModuleUsage.REQUIRED);
        loginModuleConfig.setProperties(this.initLoginModuleProperties());
        return new LoginModuleConfig[]{loginModuleConfig};
    }

    public String toString() {
        return "LdapAuthenticationConfig [url=" + this.url + ", socketFactoryClassName=" + this.socketFactoryClassName + ", systemUserDn=" + this.systemUserDn + ", systemUserPassword=***, parseDn=" + this.parseDn + ", roleContext=" + this.roleContext + ", roleFilter=" + this.roleFilter + ", roleMappingAttribute=" + this.roleMappingAttribute + ", roleMappingMode=" + (Object)((Object)this.roleMappingMode) + ", roleNameAttribute=" + this.roleNameAttribute + ", roleRecursionMaxDepth=" + this.roleRecursionMaxDepth + ", roleSearchScope=" + (Object)((Object)this.roleSearchScope) + ", userNameAttribute=" + this.userNameAttribute + ", passwordAttribute=" + this.passwordAttribute + ", userContext=" + this.userContext + ", userFilter=" + this.userFilter + ", userSearchScope=" + (Object)((Object)this.userSearchScope) + ", skipAuthentication=" + this.skipAuthentication + ", securityRealm=" + this.securityRealm + ", systemAuthentication=" + this.systemAuthentication + ", getSkipIdentity()=" + this.getSkipIdentity() + ", getSkipEndpoint()=" + this.getSkipEndpoint() + ", getSkipRole()=" + this.getSkipRole() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Objects.hash(new Object[]{this.parseDn, this.passwordAttribute, this.roleContext, this.roleFilter, this.roleMappingAttribute, this.roleMappingMode, this.roleNameAttribute, this.roleRecursionMaxDepth, this.roleSearchScope, this.skipAuthentication, this.socketFactoryClassName, this.systemUserDn, this.systemUserPassword, this.url, this.userContext, this.userFilter, this.userNameAttribute, this.userSearchScope, this.securityRealm, this.systemAuthentication});
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapAuthenticationConfig other = (LdapAuthenticationConfig)obj;
        return this.parseDn == other.parseDn && Objects.equals(this.passwordAttribute, other.passwordAttribute) && Objects.equals(this.roleContext, other.roleContext) && Objects.equals(this.roleFilter, other.roleFilter) && Objects.equals(this.roleMappingAttribute, other.roleMappingAttribute) && this.roleMappingMode == other.roleMappingMode && Objects.equals(this.roleNameAttribute, other.roleNameAttribute) && Objects.equals(this.roleRecursionMaxDepth, other.roleRecursionMaxDepth) && this.roleSearchScope == other.roleSearchScope && Objects.equals(this.skipAuthentication, other.skipAuthentication) && Objects.equals(this.socketFactoryClassName, other.socketFactoryClassName) && Objects.equals(this.systemUserDn, other.systemUserDn) && Objects.equals(this.systemUserPassword, other.systemUserPassword) && Objects.equals(this.url, other.url) && Objects.equals(this.userContext, other.userContext) && Objects.equals(this.userFilter, other.userFilter) && Objects.equals(this.securityRealm, other.securityRealm) && Objects.equals(this.systemAuthentication, other.systemAuthentication) && Objects.equals(this.userNameAttribute, other.userNameAttribute) && this.userSearchScope == other.userSearchScope;
    }

    @Override
    protected LdapAuthenticationConfig self() {
        return this;
    }
}

