/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class TieredStoreConfig
implements IdentifiedDataSerializable {
    public static final boolean DEFAULT_ENABLED = false;
    private boolean enabled = false;
    private MemoryTierConfig memoryTierConfig = new MemoryTierConfig();
    private DiskTierConfig diskTierConfig = new DiskTierConfig();

    public TieredStoreConfig() {
    }

    public TieredStoreConfig(TieredStoreConfig tieredStoreConfig) {
        this.enabled = tieredStoreConfig.isEnabled();
        this.memoryTierConfig = new MemoryTierConfig(tieredStoreConfig.getMemoryTierConfig());
        this.diskTierConfig = new DiskTierConfig(tieredStoreConfig.getDiskTierConfig());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TieredStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MemoryTierConfig getMemoryTierConfig() {
        return this.memoryTierConfig;
    }

    public TieredStoreConfig setMemoryTierConfig(MemoryTierConfig memoryTierConfig) {
        this.memoryTierConfig = memoryTierConfig;
        return this;
    }

    public DiskTierConfig getDiskTierConfig() {
        return this.diskTierConfig;
    }

    public TieredStoreConfig setDiskTierConfig(DiskTierConfig diskTierConfig) {
        this.diskTierConfig = diskTierConfig;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TieredStoreConfig)) {
            return false;
        }
        TieredStoreConfig that = (TieredStoreConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (!Objects.equals(this.memoryTierConfig, that.memoryTierConfig)) {
            return false;
        }
        return Objects.equals(this.diskTierConfig, that.diskTierConfig);
    }

    public final int hashCode() {
        int result2 = this.enabled ? 1 : 0;
        result2 = 31 * result2 + (this.memoryTierConfig != null ? this.memoryTierConfig.hashCode() : 0);
        result2 = 31 * result2 + (this.diskTierConfig != null ? this.diskTierConfig.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "TieredStoreConfig{enabled=" + this.enabled + ", memoryTierConfig=" + this.memoryTierConfig + ", diskTierConfig=" + this.diskTierConfig + '}';
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeObject(this.memoryTierConfig);
        out.writeObject(this.diskTierConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.memoryTierConfig = (MemoryTierConfig)in.readObject();
        this.diskTierConfig = (DiskTierConfig)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 64;
    }
}

