/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapQueryMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultUtils;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DefaultMapProjectMessageTask<P>
extends AbstractMapQueryMessageTask<P, QueryResult, QueryResult, List<Data>> {
    public DefaultMapProjectMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected IterationType getIterationType() {
        return IterationType.VALUE;
    }

    @Override
    protected Aggregator<?, ?> getAggregator() {
        return null;
    }

    @Override
    protected Predicate getPredicate() {
        return Predicates.alwaysTrue();
    }

    @Override
    protected void extractAndAppendResult(Collection<QueryResult> results, QueryResult result2) {
        results.add(result2);
    }

    @Override
    protected List<Data> reduce(Collection<QueryResult> results) {
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        QueryResult combinedResult = null;
        for (QueryResult result2 : results) {
            if (combinedResult == null) {
                combinedResult = result2;
                continue;
            }
            combinedResult.combine(result2);
        }
        Set result3 = QueryResultUtils.transformToSet(this.nodeEngine.getSerializationService(), combinedResult, this.getPredicate(), IterationType.VALUE, false, true);
        ArrayList<Data> serialized = new ArrayList<Data>(result3.size());
        for (Object row : result3) {
            serialized.add((Data)row);
        }
        return serialized;
    }
}

