/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import javax.transaction.xa.Xid;

public final class XidCodec {
    private static final int FORMAT_ID_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private XidCodec() {
    }

    public static void encode(ClientMessage clientMessage, Xid xid) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, xid.getFormatId());
        clientMessage.add(initialFrame);
        ByteArrayCodec.encode(clientMessage, xid.getGlobalTransactionId());
        ByteArrayCodec.encode(clientMessage, xid.getBranchQualifier());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SerializableXID decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int formatId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        byte[] globalTransactionId = ByteArrayCodec.decode(iterator2);
        byte[] branchQualifier = ByteArrayCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new SerializableXID(formatId, globalTransactionId, branchQualifier);
    }
}

