/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.SqlPageCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlColumnMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlErrorCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlQueryIdCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlPage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class SqlExecuteCodec {
    public static final int REQUEST_MESSAGE_TYPE = 2163712;
    public static final int RESPONSE_MESSAGE_TYPE = 2163713;
    private static final int REQUEST_TIMEOUT_MILLIS_FIELD_OFFSET = 16;
    private static final int REQUEST_CURSOR_BUFFER_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_EXPECTED_RESULT_TYPE_FIELD_OFFSET = 28;
    private static final int REQUEST_SKIP_UPDATE_STATISTICS_FIELD_OFFSET = 29;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 30;
    private static final int RESPONSE_UPDATE_COUNT_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 21;

    private SqlExecuteCodec() {
    }

    public static ClientMessage encodeRequest(String sql, Collection<Data> parameters, long timeoutMillis, int cursorBufferSize, @Nullable String schema, byte expectedResultType, QueryId queryId, boolean skipUpdateStatistics) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Sql.Execute");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2163712);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timeoutMillis);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, cursorBufferSize);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 28, expectedResultType);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 29, skipUpdateStatistics);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, sql);
        ListMultiFrameCodec.encodeContainsNullable(clientMessage, parameters, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, schema, StringCodec::encode);
        SqlQueryIdCodec.encode(clientMessage, queryId);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.timeoutMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.cursorBufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.expectedResultType = FixedSizeTypesCodec.decodeByte(initialFrame.content, 28);
        if (initialFrame.content.length >= 30) {
            request.skipUpdateStatistics = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 29);
            request.isSkipUpdateStatisticsExists = true;
        } else {
            request.isSkipUpdateStatisticsExists = false;
        }
        request.sql = StringCodec.decode(iterator2);
        request.parameters = ListMultiFrameCodec.decodeContainsNullable(iterator2, DataCodec::decode);
        request.schema = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        request.queryId = SqlQueryIdCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable List<SqlColumnMetadata> rowMetadata, @Nullable SqlPage rowPage, long updateCount, @Nullable SqlError error) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2163713);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, updateCount);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encodeNullable(clientMessage, rowMetadata, SqlColumnMetadataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, rowPage, SqlPageCodec::encode);
        CodecUtil.encodeNullable(clientMessage, error, SqlErrorCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        response.updateCount = FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
        response.rowMetadata = ListMultiFrameCodec.decodeNullable(iterator2, SqlColumnMetadataCodec::decode);
        response.rowPage = CodecUtil.decodeNullable(iterator2, SqlPageCodec::decode);
        response.error = CodecUtil.decodeNullable(iterator2, SqlErrorCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public List<SqlColumnMetadata> rowMetadata;
        @Nullable
        public SqlPage rowPage;
        public long updateCount;
        @Nullable
        public SqlError error;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String sql;
        public List<Data> parameters;
        public long timeoutMillis;
        public int cursorBufferSize;
        @Nullable
        public String schema;
        public byte expectedResultType;
        public QueryId queryId;
        public boolean skipUpdateStatistics;
        public boolean isSkipUpdateStatisticsExists;
    }
}

