/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class CacheListenerRegistrationCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1249024;
    public static final int RESPONSE_MESSAGE_TYPE = 1249025;
    private static final int REQUEST_SHOULD_REGISTER_FIELD_OFFSET = 16;
    private static final int REQUEST_UUID_FIELD_OFFSET = 17;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private CacheListenerRegistrationCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data listenerConfig, boolean shouldRegister, UUID uuid) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Cache.ListenerRegistration");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1249024);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, shouldRegister);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 17, uuid);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, listenerConfig);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.shouldRegister = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 17);
        request.name = StringCodec.decode(iterator2);
        request.listenerConfig = DataCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1249025);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data listenerConfig;
        public boolean shouldRegister;
        public UUID uuid;
    }
}

