/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ErrorsCodec;
import com.hazelcast.client.impl.protocol.exception.ErrorHolder;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.ConsistencyLostException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.exception.CannotReplicateException;
import com.hazelcast.cp.exception.LeaderDemotedException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.exception.StaleAppendRequestException;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.session.SessionExpiredException;
import com.hazelcast.cp.lock.exception.LockAcquireLimitReachedException;
import com.hazelcast.cp.lock.exception.LockOwnershipLostException;
import com.hazelcast.crdt.MutationDisallowedException;
import com.hazelcast.crdt.TargetNotReplicaException;
import com.hazelcast.durableexecutor.StaleTaskIdException;
import com.hazelcast.flakeidgen.impl.NodeIdOutOfRangeException;
import com.hazelcast.internal.cluster.impl.ConfigMismatchException;
import com.hazelcast.internal.cluster.impl.VersionMismatchException;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.query.QueryException;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.scheduledexecutor.DuplicateTaskException;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionTimedOutException;
import com.hazelcast.wan.WanQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;

public class ClientExceptionFactory {
    private final Map<Integer, ExceptionFactory> intToFactory = new HashMap<Integer, ExceptionFactory>();
    private final Map<Class, Integer> classToInt = new HashMap<Class, Integer>();
    private final ClassLoader classLoader;

    public ClientExceptionFactory(boolean jcacheAvailable, ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (jcacheAvailable) {
            this.register(4, CacheException.class, CacheException::new);
            this.register(5, CacheLoaderException.class, CacheLoaderException::new);
            this.register(7, CacheWriterException.class, CacheWriterException::new);
            this.register(16, EntryProcessorException.class, EntryProcessorException::new);
        }
        this.register(1, ArrayIndexOutOfBoundsException.class, (message, cause) -> new ArrayIndexOutOfBoundsException(message));
        this.register(2, ArrayStoreException.class, (message, cause) -> new ArrayStoreException(message));
        this.register(3, AuthenticationException.class, (message, cause) -> new AuthenticationException(message));
        this.register(6, CacheNotExistsException.class, (message, cause) -> new CacheNotExistsException(message));
        this.register(8, CallerNotMemberException.class, (message, cause) -> new CallerNotMemberException(message));
        this.register(9, CancellationException.class, (message, cause) -> new CancellationException(message));
        this.register(10, ClassCastException.class, (message, cause) -> new ClassCastException(message));
        this.register(11, ClassNotFoundException.class, ClassNotFoundException::new);
        this.register(12, ConcurrentModificationException.class, (message, cause) -> new ConcurrentModificationException(message));
        this.register(13, ConfigMismatchException.class, (message, cause) -> new ConfigMismatchException(message));
        this.register(14, DistributedObjectDestroyedException.class, (message, cause) -> new DistributedObjectDestroyedException(message));
        this.register(15, EOFException.class, (message, cause) -> new EOFException(message));
        this.register(17, ExecutionException.class, ExecutionException::new);
        this.register(18, HazelcastException.class, HazelcastException::new);
        this.register(19, HazelcastInstanceNotActiveException.class, (message, cause) -> new HazelcastInstanceNotActiveException(message));
        this.register(20, HazelcastOverloadException.class, (message, cause) -> new HazelcastOverloadException(message));
        this.register(21, HazelcastSerializationException.class, HazelcastSerializationException::new);
        this.register(22, IOException.class, IOException::new);
        this.register(23, IllegalArgumentException.class, IllegalArgumentException::new);
        this.register(24, IllegalAccessException.class, (message, cause) -> new IllegalAccessException(message));
        this.register(25, IllegalAccessError.class, (message, cause) -> new IllegalAccessError(message));
        this.register(26, IllegalMonitorStateException.class, (message, cause) -> new IllegalMonitorStateException(message));
        this.register(27, IllegalStateException.class, IllegalStateException::new);
        this.register(28, IllegalThreadStateException.class, (message, cause) -> new IllegalThreadStateException(message));
        this.register(29, IndexOutOfBoundsException.class, (message, cause) -> new IndexOutOfBoundsException(message));
        this.register(30, InterruptedException.class, (message, cause) -> new InterruptedException(message));
        this.register(31, AddressUtil.InvalidAddressException.class, (message, cause) -> new AddressUtil.InvalidAddressException(message, false));
        this.register(32, InvalidConfigurationException.class, InvalidConfigurationException::new);
        this.register(33, MemberLeftException.class, (message, cause) -> new MemberLeftException(message));
        this.register(34, NegativeArraySizeException.class, (message, cause) -> new NegativeArraySizeException(message));
        this.register(35, NoSuchElementException.class, (message, cause) -> new NoSuchElementException(message));
        this.register(36, NotSerializableException.class, (message, cause) -> new NotSerializableException(message));
        this.register(37, NullPointerException.class, (message, cause) -> new NullPointerException(message));
        this.register(38, OperationTimeoutException.class, (message, cause) -> new OperationTimeoutException(message));
        this.register(39, PartitionMigratingException.class, (message, cause) -> new PartitionMigratingException(message));
        this.register(40, QueryException.class, QueryException::new);
        this.register(41, QueryResultSizeExceededException.class, (message, cause) -> new QueryResultSizeExceededException(message));
        this.register(42, SplitBrainProtectionException.class, (message, cause) -> new SplitBrainProtectionException(message));
        this.register(43, ReachedMaxSizeException.class, (message, cause) -> new ReachedMaxSizeException(message));
        this.register(44, RejectedExecutionException.class, RejectedExecutionException::new);
        this.register(45, ResponseAlreadySentException.class, (message, cause) -> new ResponseAlreadySentException(message));
        this.register(46, RetryableHazelcastException.class, RetryableHazelcastException::new);
        this.register(47, RetryableIOException.class, RetryableIOException::new);
        this.register(48, RuntimeException.class, RuntimeException::new);
        this.register(49, SecurityException.class, SecurityException::new);
        this.register(50, SocketException.class, (message, cause) -> new SocketException(message));
        this.register(51, StaleSequenceException.class, (message, cause) -> new StaleSequenceException(message, 0L));
        this.register(52, TargetDisconnectedException.class, (message, cause) -> new TargetDisconnectedException(message));
        this.register(53, TargetNotMemberException.class, (message, cause) -> new TargetNotMemberException(message));
        this.register(54, TimeoutException.class, (message, cause) -> new TimeoutException(message));
        this.register(55, TopicOverloadException.class, (message, cause) -> new TopicOverloadException(message));
        this.register(56, TransactionException.class, TransactionException::new);
        this.register(57, TransactionNotActiveException.class, (message, cause) -> new TransactionNotActiveException(message));
        this.register(58, TransactionTimedOutException.class, TransactionTimedOutException::new);
        this.register(59, URISyntaxException.class, (message, cause) -> new URISyntaxException("not available", message));
        this.register(60, UTFDataFormatException.class, (message, cause) -> new UTFDataFormatException(message));
        this.register(61, UnsupportedOperationException.class, UnsupportedOperationException::new);
        this.register(62, WrongTargetException.class, (message, cause) -> new WrongTargetException(message));
        this.register(63, XAException.class, (message, cause) -> new XAException(message));
        this.register(64, AccessControlException.class, (message, cause) -> new AccessControlException(message));
        this.register(65, LoginException.class, (message, cause) -> new LoginException(message));
        this.register(66, UnsupportedCallbackException.class, (message, cause) -> new UnsupportedCallbackException(null, message));
        this.register(67, NoDataMemberInClusterException.class, (message, cause) -> new NoDataMemberInClusterException(message));
        this.register(68, ReplicatedMapCantBeCreatedOnLiteMemberException.class, (message, cause) -> new ReplicatedMapCantBeCreatedOnLiteMemberException(message));
        this.register(69, MaxMessageSizeExceeded.class, (message, cause) -> new MaxMessageSizeExceeded(message));
        this.register(70, WanQueueFullException.class, (message, cause) -> new WanQueueFullException(message));
        this.register(71, AssertionError.class, (message, cause) -> new AssertionError((Object)message));
        this.register(72, OutOfMemoryError.class, (message, cause) -> new OutOfMemoryError(message));
        this.register(73, StackOverflowError.class, (message, cause) -> new StackOverflowError(message));
        this.register(74, NativeOutOfMemoryError.class, NativeOutOfMemoryError::new);
        this.register(75, ServiceNotFoundException.class, (message, cause) -> new ServiceNotFoundException(message));
        this.register(76, StaleTaskIdException.class, (message, cause) -> new StaleTaskIdException(message));
        this.register(77, DuplicateTaskException.class, (message, cause) -> new DuplicateTaskException(message));
        this.register(78, StaleTaskException.class, (message, cause) -> new StaleTaskException(message));
        this.register(79, LocalMemberResetException.class, (message, cause) -> new LocalMemberResetException(message));
        this.register(80, IndeterminateOperationStateException.class, IndeterminateOperationStateException::new);
        this.register(81, NodeIdOutOfRangeException.class, (message, cause) -> new NodeIdOutOfRangeException(message));
        this.register(82, TargetNotReplicaException.class, (message, cause) -> new TargetNotReplicaException(message));
        this.register(83, MutationDisallowedException.class, (message, cause) -> new MutationDisallowedException(message));
        this.register(84, ConsistencyLostException.class, (message, cause) -> new ConsistencyLostException(message));
        this.register(85, SessionExpiredException.class, SessionExpiredException::new);
        this.register(86, WaitKeyCancelledException.class, WaitKeyCancelledException::new);
        this.register(87, LockAcquireLimitReachedException.class, (message, cause) -> new LockAcquireLimitReachedException(message));
        this.register(88, LockOwnershipLostException.class, (message, cause) -> new LockOwnershipLostException(message));
        this.register(89, CPGroupDestroyedException.class, (message, cause) -> new CPGroupDestroyedException());
        this.register(90, CannotReplicateException.class, (message, cause) -> new CannotReplicateException(null));
        this.register(91, LeaderDemotedException.class, (message, cause) -> new LeaderDemotedException(null, null));
        this.register(92, StaleAppendRequestException.class, (message, cause) -> new StaleAppendRequestException(null));
        this.register(93, NotLeaderException.class, (message, cause) -> new NotLeaderException(null, null, null));
        this.register(94, VersionMismatchException.class, (message, cause) -> new VersionMismatchException(message));
        this.register(95, NoSuchMethodError.class, (message, cause) -> new NoSuchMethodError(message));
        this.register(96, NoSuchMethodException.class, (message, cause) -> new NoSuchMethodException(message));
        this.register(97, NoSuchFieldError.class, (message, cause) -> new NoSuchFieldError(message));
        this.register(98, NoSuchFieldException.class, (message, cause) -> new NoSuchFieldException(message));
        this.register(99, NoClassDefFoundError.class, (message, cause) -> new NoClassDefFoundError(message));
    }

    public Throwable createException(ClientMessage clientMessage) {
        List<ErrorHolder> errorHolders = ErrorsCodec.decode(clientMessage);
        return this.createException(errorHolders.iterator());
    }

    private Throwable createException(Iterator<ErrorHolder> iterator2) {
        if (!iterator2.hasNext()) {
            return null;
        }
        ErrorHolder errorHolder = iterator2.next();
        ExceptionFactory exceptionFactory = this.intToFactory.get(errorHolder.getErrorCode());
        Throwable throwable = null;
        if (exceptionFactory == null) {
            String className = errorHolder.getClassName();
            try {
                Class<?> exceptionClass = ClassLoaderUtil.loadClass(this.classLoader, className);
                throwable = ExceptionUtil.tryCreateExceptionWithMessageAndCause(exceptionClass, errorHolder.getMessage(), this.createException(iterator2));
            }
            catch (ClassNotFoundException e) {
                EmptyStatement.ignore(e);
            }
            if (throwable == null) {
                throwable = new UndefinedErrorCodeException(errorHolder.getMessage(), className, this.createException(iterator2));
            }
        } else {
            throwable = exceptionFactory.createException(errorHolder.getMessage(), this.createException(iterator2));
        }
        throwable.setStackTrace(errorHolder.getStackTraceElements().toArray(new StackTraceElement[0]));
        return throwable;
    }

    private boolean checkClassNameForValidity(String exceptionClassName) {
        return !exceptionClassName.startsWith("com.hazelcast") && !exceptionClassName.startsWith("java");
    }

    public void register(int errorCode, Class clazz, ExceptionFactory exceptionFactory) {
        if (this.intToFactory.putIfAbsent(errorCode, exceptionFactory) != null) {
            throw new HazelcastException("Code " + errorCode + " already used");
        }
        if (!clazz.equals(exceptionFactory.createException("", null).getClass())) {
            throw new HazelcastException("Exception factory did not produce an instance of expected class");
        }
        Integer currentCode = this.classToInt.putIfAbsent(clazz, errorCode);
        if (currentCode != null) {
            throw new HazelcastException("Class " + clazz.getName() + " already added with code: " + currentCode);
        }
    }

    public ClientMessage createExceptionMessage(Throwable throwable) {
        LinkedList<ErrorHolder> errorHolders = new LinkedList<ErrorHolder>();
        errorHolders.add(this.convertToErrorHolder(throwable));
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            errorHolders.add(this.convertToErrorHolder(cause));
        }
        return ErrorsCodec.encode(errorHolders);
    }

    private ErrorHolder convertToErrorHolder(Throwable t) {
        Integer errorCode = this.classToInt.get(t.getClass());
        if (errorCode == null) {
            errorCode = 0;
        }
        return new ErrorHolder(errorCode, t.getClass().getName(), t.getMessage(), Arrays.asList(t.getStackTrace()));
    }

    boolean isKnownClass(Class<? extends Throwable> aClass) {
        return this.classToInt.containsKey(aClass);
    }

    public static interface ExceptionFactory {
        public Throwable createException(String var1, Throwable var2);
    }
}

