/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.impl.QueryCacheConfigBuilderHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class AbstractQueryCacheConfigBuilderHelper
implements QueryCacheConfigBuilderHelper {
    protected final boolean domLevel3;
    protected final boolean strict;

    protected AbstractQueryCacheConfigBuilderHelper(boolean domLevel3, boolean strict) {
        this.domLevel3 = domLevel3;
        this.strict = strict;
    }

    protected AbstractQueryCacheConfigBuilderHelper(boolean domLevel3) {
        this.domLevel3 = domLevel3;
        this.strict = true;
    }

    protected String getTextContent(Node node) {
        return DomConfigHelper.getTextContent(node, this.domLevel3);
    }

    protected void populateQueryCacheConfig(QueryCacheConfig queryCacheConfig, Node childNode, String nodeName) {
        if (this.matches("entry-listeners", nodeName)) {
            this.handleEntryListeners(queryCacheConfig, childNode);
        } else if (this.matches("include-value", nodeName)) {
            boolean includeValue = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
            queryCacheConfig.setIncludeValue(includeValue);
        } else if (this.matches("batch-size", nodeName)) {
            int batchSize = DomConfigHelper.getIntegerValue("batch-size", this.getTextContent(childNode));
            queryCacheConfig.setBatchSize(batchSize);
        } else if (this.matches("buffer-size", nodeName)) {
            int bufferSize = DomConfigHelper.getIntegerValue("buffer-size", this.getTextContent(childNode));
            queryCacheConfig.setBufferSize(bufferSize);
        } else if (this.matches("delay-seconds", nodeName)) {
            int delaySeconds = DomConfigHelper.getIntegerValue("delay-seconds", this.getTextContent(childNode));
            queryCacheConfig.setDelaySeconds(delaySeconds);
        } else if (this.matches("in-memory-format", nodeName)) {
            queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(childNode))));
        } else if (this.matches("coalesce", nodeName)) {
            boolean coalesce = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
            queryCacheConfig.setCoalesce(coalesce);
        } else if (this.matches("populate", nodeName)) {
            boolean populate = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
            queryCacheConfig.setPopulate(populate);
        } else if (this.matches("serialize-keys", nodeName)) {
            boolean serializeKeys = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
            queryCacheConfig.setSerializeKeys(serializeKeys);
        } else if (this.matches("indexes", nodeName)) {
            this.queryCacheIndexesHandle(childNode, queryCacheConfig);
        } else if (this.matches("predicate", nodeName)) {
            this.queryCachePredicateHandler(childNode, queryCacheConfig);
        } else if (this.matches("eviction", nodeName)) {
            queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode));
        }
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size2 = this.getNamedItemNode(node, "size");
        Node maxSizePolicy = this.getNamedItemNode(node, "max-size-policy");
        Node evictionPolicy = this.getNamedItemNode(node, "eviction-policy");
        Node comparatorClassName = this.getNamedItemNode(node, "comparator-class-name");
        if (size2 != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size2)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaxSizePolicy(MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(this.getTextContent(comparatorClassName));
        }
        return evictionConfig;
    }

    protected abstract String getCacheName(Node var1);

    protected void handleQueryCacheNode(ClientConfig clientConfig, Node queryCacheNode) {
        NamedNodeMap attrs = queryCacheNode.getAttributes();
        String cacheName = this.getCacheName(queryCacheNode);
        String mapName = this.getCacheMapName(attrs);
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
        for (Node childNode : DomConfigHelper.childElements(queryCacheNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(childNode);
            this.populateQueryCacheConfig(queryCacheConfig, childNode, nodeName);
        }
        clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
    }

    protected abstract String getCacheMapName(NamedNodeMap var1);

    protected abstract void handleEntryListeners(QueryCacheConfig var1, Node var2);

    protected void handleEntryListenerNode(QueryCacheConfig queryCacheConfig, Node listenerNode) {
        boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
        boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "local")));
        String listenerClass = this.getTextContent(listenerNode);
        queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
    }

    protected abstract void queryCachePredicateHandler(Node var1, QueryCacheConfig var2);

    protected abstract void queryCacheIndexesHandle(Node var1, QueryCacheConfig var2);

    protected boolean matches(String config1, String config2) {
        return this.strict ? config1 != null && config1.equals(config2) : ConfigUtils.matches(config1, config2);
    }

    protected Node getNamedItemNode(Node node, String attrName) {
        return this.getNamedItemNode(node.getAttributes(), attrName);
    }

    protected Node getNamedItemNode(NamedNodeMap attrs, String attrName) {
        if (this.strict) {
            return attrs.getNamedItem(attrName);
        }
        Node attrNode = attrs.getNamedItem(attrName);
        return attrNode != null ? attrNode : attrs.getNamedItem(attrName.replace("-", ""));
    }
}

