/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.CacheOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Map;

public class CachePutAllBackupOperation
extends CacheOperation
implements BackupOperation {
    private Map<Data, CacheRecord> cacheRecords;

    public CachePutAllBackupOperation() {
    }

    public CachePutAllBackupOperation(String cacheNameWithPrefix, Map<Data, CacheRecord> cacheRecords) {
        super(cacheNameWithPrefix);
        this.cacheRecords = cacheRecords;
    }

    @Override
    public void run() throws Exception {
        if (this.recordStore == null) {
            return;
        }
        if (this.cacheRecords != null) {
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                CacheRecord record = entry.getValue();
                this.recordStore.putRecord(entry.getKey(), record, true);
                this.publishWanUpdate(entry.getKey(), record);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.cacheRecords != null);
        if (this.cacheRecords != null) {
            out.writeInt(this.cacheRecords.size());
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                Data key = entry.getKey();
                CacheRecord record = entry.getValue();
                IOUtil.writeData(out, key);
                out.writeObject(record);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean recordNotNull = in.readBoolean();
        if (recordNotNull) {
            int size2 = in.readInt();
            this.cacheRecords = MapUtil.createHashMap(size2);
            for (int i = 0; i < size2; ++i) {
                Data key = IOUtil.readData(in);
                CacheRecord record = (CacheRecord)in.readObject();
                this.cacheRecords.put(key, record);
            }
        }
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public boolean requiresTenantContext() {
        return true;
    }
}

