/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.DeferredValue;
import com.hazelcast.config.AbstractCacheConfig;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import java.io.IOException;

public class PreJoinCacheConfig<K, V>
extends CacheConfig<K, V>
implements Versioned {
    public PreJoinCacheConfig() {
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig) {
        this(cacheConfig, true);
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig, boolean resolved) {
        cacheConfig.copy(this, resolved);
    }

    @Override
    protected void writeKeyValueTypes(ObjectDataOutput out) throws IOException {
        out.writeString(this.getKeyClassName());
        out.writeString(this.getValueClassName());
    }

    @Override
    protected void readKeyValueTypes(ObjectDataInput in) throws IOException {
        this.setKeyClassName(in.readString());
        this.setValueClassName(in.readString());
    }

    @Override
    protected void writeFactories(ObjectDataOutput out) throws IOException {
        assert (out instanceof SerializationServiceSupport) : "out must implement SerializationServiceSupport";
        SerializationService serializationService = ((SerializationServiceSupport)((Object)out)).getSerializationService();
        IOUtil.writeData(out, this.cacheLoaderFactory.getSerializedValue(serializationService));
        IOUtil.writeData(out, this.cacheWriterFactory.getSerializedValue(serializationService));
        IOUtil.writeData(out, this.expiryPolicyFactory.getSerializedValue(serializationService));
    }

    @Override
    protected void readFactories(ObjectDataInput in) throws IOException {
        this.cacheLoaderFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
        this.cacheWriterFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
        this.expiryPolicyFactory = DeferredValue.withSerializedValue(IOUtil.readData(in));
    }

    @Override
    protected void writeListenerConfigurations(ObjectDataOutput out) throws IOException {
        assert (out instanceof SerializationServiceSupport) : "out must implement SerializationServiceSupport";
        out.writeInt(this.listenerConfigurations.size());
        for (DeferredValue config : this.listenerConfigurations) {
            IOUtil.writeData(out, config.getSerializedValue(((SerializationServiceSupport)((Object)out)).getSerializationService()));
        }
    }

    @Override
    protected void readListenerConfigurations(ObjectDataInput in) throws IOException {
        int size2 = in.readInt();
        this.listenerConfigurations = this.createConcurrentSet();
        for (int i = 0; i < size2; ++i) {
            DeferredValue serializedConfig = DeferredValue.withSerializedValue(IOUtil.readData(in));
            this.listenerConfigurations.add(serializedConfig);
        }
    }

    @Override
    public int getClassId() {
        return 57;
    }

    CacheConfig<K, V> asCacheConfig() {
        return this.copy(new CacheConfig(), false);
    }

    @Override
    protected boolean keyValueTypesEqual(AbstractCacheConfig that) {
        if (!this.getKeyClassName().equals(that.getKeyClassName())) {
            return false;
        }
        return this.getValueClassName().equals(that.getValueClassName());
    }

    public static <K, V> CacheConfig<K, V> asCacheConfig(CacheConfig<K, V> cacheConfig) {
        if (!(cacheConfig instanceof PreJoinCacheConfig)) {
            return cacheConfig;
        }
        return ((PreJoinCacheConfig)cacheConfig).asCacheConfig();
    }

    public static <K, V> PreJoinCacheConfig<K, V> of(CacheConfig<K, V> cacheConfig) {
        if (cacheConfig instanceof PreJoinCacheConfig) {
            return (PreJoinCacheConfig)cacheConfig;
        }
        return new PreJoinCacheConfig<K, V>(cacheConfig, false);
    }
}

